/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.time.Duration;
import java.util.function.Function;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import reactor.util.annotation.Nullable;

abstract class AbstractHttpServerMetricsHandler
extends ChannelDuplexHandler {
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final Function<String, String> uriTagValue;

    protected AbstractHttpServerMetricsHandler(@Nullable Function<String, String> uriTagValue) {
        this.uriTagValue = uriTagValue;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        if (this.recorder() instanceof MicrometerHttpServerMetricsRecorder) {
            this.recorder().recordServerConnectionOpened(ctx.channel().localAddress());
        }
        ctx.fireChannelActive();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.recorder() instanceof MicrometerHttpServerMetricsRecorder) {
            this.recorder().recordServerConnectionClosed(ctx.channel().localAddress());
        }
        ctx.fireChannelInactive();
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponse) {
            if (((HttpResponse)msg).status().equals(HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
            this.dataSentTime = System.nanoTime();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataSent += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataSent += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
                if (channelOps instanceof HttpServerOperations) {
                    HttpServerOperations ops = (HttpServerOperations)channelOps;
                    this.recordWrite(ops, this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path), ops.method().name(), ops.status().codeAsText().toString());
                    this.recordInactiveConnection(ops);
                }
                this.dataSent = 0L;
            }));
        }
        ctx.write(msg, promise);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        HttpServerOperations ops;
        ChannelOperations<?, ?> channelOps;
        if (msg instanceof HttpRequest) {
            this.dataReceivedTime = System.nanoTime();
            channelOps = ChannelOperations.get(ctx.channel());
            if (channelOps instanceof HttpServerOperations) {
                ops = (HttpServerOperations)channelOps;
                this.recordActiveConnection(ops);
            }
        }
        if (msg instanceof ByteBufHolder) {
            this.dataReceived += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataReceived += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            channelOps = ChannelOperations.get(ctx.channel());
            if (channelOps instanceof HttpServerOperations) {
                ops = (HttpServerOperations)channelOps;
                this.recordRead(ops, this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path), ops.method().name());
            }
            this.dataReceived = 0L;
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
        if (channelOps instanceof HttpServerOperations) {
            HttpServerOperations ops = (HttpServerOperations)channelOps;
            this.recordException(ops, this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path));
        }
        ctx.fireExceptionCaught(cause);
    }

    protected abstract HttpServerMetricsRecorder recorder();

    protected void recordException(HttpServerOperations ops, String path2) {
        this.recorder().incrementErrorsCount(ops.remoteAddress(), path2);
    }

    protected void recordRead(HttpServerOperations ops, String path2, String method2) {
        this.recorder().recordDataReceivedTime(path2, method2, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordDataReceived(ops.remoteAddress(), path2, this.dataReceived);
    }

    protected void recordWrite(HttpServerOperations ops, String path2, String method2, String status) {
        Duration dataSentTimeDuration = Duration.ofNanos(System.nanoTime() - this.dataSentTime);
        this.recorder().recordDataSentTime(path2, method2, status, dataSentTimeDuration);
        if (this.dataReceivedTime != 0L) {
            this.recorder().recordResponseTime(path2, method2, status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        } else {
            this.recorder().recordResponseTime(path2, method2, status, dataSentTimeDuration);
        }
        this.recorder().recordDataSent(ops.remoteAddress(), path2, this.dataSent);
    }

    protected void recordActiveConnection(HttpServerOperations ops) {
        this.recorder().recordServerConnectionActive(ops.hostAddress());
    }

    protected void recordInactiveConnection(HttpServerOperations ops) {
        this.recorder().recordServerConnectionInactive(ops.hostAddress());
    }
}

