/*
 * Decompiled with CFR 0.152.
 */
package joptsimple.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public enum PathProperties {
    FILE_EXISTING("file.existing"){

        @Override
        boolean accept(Path path2) {
            return Files.isRegularFile(path2, new LinkOption[0]);
        }
    }
    ,
    DIRECTORY_EXISTING("directory.existing"){

        @Override
        boolean accept(Path path2) {
            return Files.isDirectory(path2, new LinkOption[0]);
        }
    }
    ,
    NOT_EXISTING("file.not.existing"){

        @Override
        boolean accept(Path path2) {
            return Files.notExists(path2, new LinkOption[0]);
        }
    }
    ,
    FILE_OVERWRITABLE("file.overwritable"){

        @Override
        boolean accept(Path path2) {
            return FILE_EXISTING.accept(path2) && WRITABLE.accept(path2);
        }
    }
    ,
    READABLE("file.readable"){

        @Override
        boolean accept(Path path2) {
            return Files.isReadable(path2);
        }
    }
    ,
    WRITABLE("file.writable"){

        @Override
        boolean accept(Path path2) {
            return Files.isWritable(path2);
        }
    };

    private final String messageKey;

    private PathProperties(String messageKey) {
        this.messageKey = messageKey;
    }

    abstract boolean accept(Path var1);

    String getMessageKey() {
        return this.messageKey;
    }
}

