/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClientState;
import reactor.util.Logger;
import reactor.util.Loggers;

final class HttpTrafficHandler
extends ChannelInboundHandlerAdapter {
    final ConnectionObserver listener;
    static final Logger log = Loggers.getLogger(HttpTrafficHandler.class);

    HttpTrafficHandler(ConnectionObserver listener) {
        this.listener = listener;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        if (channel.isActive()) {
            if (ctx.pipeline().get("reactor.left.h2MultiplexHandler") == null) {
                ctx.fireChannelActive();
            } else if (ctx.pipeline().get("reactor.left.sslHandler") == null) {
                this.sendNewState(Connection.from(channel), ConnectionObserver.State.CONNECTED);
                ctx.flush();
                ctx.read();
            } else {
                this.sendNewState(Connection.from(channel), ConnectionObserver.State.CONNECTED);
            }
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Http2SettingsFrame) {
            this.sendNewState(Connection.from(ctx.channel()), ConnectionObserver.State.CONFIGURED);
            ctx.pipeline().remove("reactor.right.reactiveBridge");
            ctx.pipeline().remove(this);
            return;
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        Channel channel = ctx.channel();
        if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "An upgrade request was sent to the server."));
            }
        } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "The upgrade to H2C protocol was successful."));
            }
            this.sendNewState(Connection.from(channel), HttpClientState.UPGRADE_SUCCESSFUL);
            ctx.pipeline().remove(this);
        } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "The upgrade to H2C protocol was rejected, continue using HTTP/1.x protocol."));
            }
            this.sendNewState(Connection.from(channel), HttpClientState.UPGRADE_REJECTED);
        }
        ctx.fireUserEventTriggered(evt);
    }

    void sendNewState(Connection connection, ConnectionObserver.State state) {
        ChannelOperations ops = connection.as(ChannelOperations.class);
        if (ops != null) {
            this.listener.onStateChange(ops, state);
        } else {
            this.listener.onStateChange(connection, state);
        }
    }
}

