/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.JavaVersion;
import org.eclipse.jetty.util.PatternMatcher;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.JarFileResource;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebInfConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(WebInfConfiguration.class);
    public static final String TEMPDIR_CONFIGURED = "org.eclipse.jetty.tmpdirConfigured";
    public static final String CONTAINER_JAR_PATTERN = "org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern";
    public static final String WEBINF_JAR_PATTERN = "org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern";
    public static final String RESOURCE_DIRS = "org.eclipse.jetty.resources";
    protected Resource _preUnpackBaseResource;

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        this.resolveTempDirectory(context);
        this.unpack(context);
        this.findAndFilterContainerPaths(context);
        this.findAndFilterWebAppPaths(context);
        context.getMetaData().setWebInfClassesDirs(this.findClassDirs(context));
    }

    public void findAndFilterContainerPaths(WebAppContext context) throws Exception {
        String[] entries;
        String tmp;
        int currentPlatform;
        int targetPlatform = currentPlatform = JavaVersion.VERSION.getPlatform();
        Object target = context.getAttribute("org.eclipse.jetty.javaTargetPlatform");
        if (target != null) {
            targetPlatform = Integer.parseInt(target.toString());
        }
        Pattern containerPattern = (tmp = (String)context.getAttribute(CONTAINER_JAR_PATTERN)) == null ? null : Pattern.compile(tmp);
        ContainerPathNameMatcher containerPathNameMatcher = new ContainerPathNameMatcher(context, containerPattern);
        ClassLoader loader = null;
        if (context.getClassLoader() != null) {
            loader = context.getClassLoader().getParent();
        }
        ArrayList<URI> containerUris = new ArrayList<URI>();
        while (loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            if (urls != null) {
                for (URL u : urls) {
                    try {
                        containerUris.add(u.toURI());
                    }
                    catch (URISyntaxException e) {
                        containerUris.add(new URI(URIUtil.encodeSpaces(u.toString())));
                    }
                }
            }
            loader = loader.getParent();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Matching container urls {}", containerUris);
        }
        containerPathNameMatcher.match(containerUris);
        if (currentPlatform >= 9 && (tmp = System.getProperty("java.class.path")) != null) {
            ArrayList<URI> cpUris = new ArrayList<URI>();
            for (String entry : entries = tmp.split(File.pathSeparator)) {
                File f = new File(entry);
                cpUris.add(f.toURI());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Matching java.class.path {}", cpUris);
            }
            containerPathNameMatcher.match(cpUris);
        }
        if (targetPlatform >= 9 && (tmp = System.getProperty("jdk.module.path")) != null) {
            ArrayList<URI> moduleUris = new ArrayList<URI>();
            for (String entry : entries = tmp.split(File.pathSeparator)) {
                File file = new File(entry);
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    if (files == null) continue;
                    for (File f : files) {
                        moduleUris.add(f.toURI());
                    }
                    continue;
                }
                moduleUris.add(file.toURI());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Matching jdk.module.path {}", moduleUris);
            }
            containerPathNameMatcher.match(moduleUris);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Container paths selected:{}", context.getMetaData().getContainerResources());
        }
    }

    public void findAndFilterWebAppPaths(WebAppContext context) throws Exception {
        String tmp = (String)context.getAttribute(WEBINF_JAR_PATTERN);
        Pattern webInfPattern = tmp == null ? null : Pattern.compile(tmp);
        WebAppPathNameMatcher matcher = new WebAppPathNameMatcher(context, webInfPattern);
        List<Resource> jars = this.findJars(context);
        if (jars != null) {
            ArrayList<URI> uris = new ArrayList<URI>();
            boolean i2 = false;
            for (Resource r : jars) {
                uris.add(r.getURI());
            }
            matcher.match(uris);
        }
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        Set resources2;
        if (context.isStarted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot configure webapp " + context + " after it is started", new Object[0]);
            }
            return;
        }
        Resource webInf = context.getWebInf();
        if (webInf != null && webInf.isDirectory() && context.getClassLoader() instanceof WebAppClassLoader) {
            Resource lib;
            Resource classes = webInf.addPath("classes/");
            if (classes.exists()) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(classes);
            }
            if ((lib = webInf.addPath("lib/")).exists() || lib.isDirectory()) {
                ((WebAppClassLoader)context.getClassLoader()).addJars(lib);
            }
        }
        if ((resources2 = (Set)context.getAttribute(RESOURCE_DIRS)) != null && !resources2.isEmpty()) {
            Resource[] collection = new Resource[resources2.size() + 1];
            int i2 = 0;
            collection[i2++] = context.getBaseResource();
            for (Resource resource : resources2) {
                collection[i2++] = resource;
            }
            context.setBaseResource(new ResourceCollection(collection));
        }
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        Boolean tmpdirConfigured;
        File tempDirectory = context.getTempDirectory();
        if (!context.isPersistTempDirectory()) {
            IO.delete(tempDirectory);
        }
        if ((tmpdirConfigured = (Boolean)context.getAttribute(TEMPDIR_CONFIGURED)) != null && !tmpdirConfigured.booleanValue()) {
            context.setTempDirectory(null);
        }
        if (context.getBaseResource() != null) {
            context.getBaseResource().close();
        }
        context.setBaseResource(this._preUnpackBaseResource);
    }

    @Override
    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        Path tmpDir = Files.createTempDirectory(template.getTempDirectory().getParentFile().toPath(), WebInfConfiguration.getCanonicalNameForWebAppTmpDir(context), new FileAttribute[0]);
        File tmpDirAsFile = tmpDir.toFile();
        tmpDirAsFile.deleteOnExit();
        context.setTempDirectory(tmpDirAsFile);
    }

    public void resolveTempDirectory(WebAppContext context) throws Exception {
        File work;
        File tmpDir = context.getTempDirectory();
        if (tmpDir != null) {
            this.configureTempDirectory(tmpDir, context);
            context.setAttribute(TEMPDIR_CONFIGURED, Boolean.TRUE);
            return;
        }
        File servletTmpDir = this.asFile(context.getAttribute("javax.servlet.context.tempdir"));
        if (servletTmpDir != null) {
            tmpDir = servletTmpDir;
            this.configureTempDirectory(tmpDir, context);
            context.setAttribute("javax.servlet.context.tempdir", tmpDir);
            context.setTempDirectory(tmpDir);
            return;
        }
        File baseTemp = this.asFile(context.getAttribute("org.eclipse.jetty.webapp.basetempdir"));
        if (baseTemp != null) {
            if (!baseTemp.isDirectory() || !baseTemp.canWrite()) {
                throw new IllegalStateException("BASETEMPDIR is not a writable directory");
            }
            this.makeTempDirectory(baseTemp, context);
            return;
        }
        File jettyBase = this.asFile(System.getProperty("jetty.base"));
        if (jettyBase != null && (work = new File(jettyBase, "work")).exists() && work.isDirectory() && work.canWrite()) {
            context.setPersistTempDirectory(true);
            this.makeTempDirectory(work, context);
            return;
        }
        this.makeTempDirectory(new File(System.getProperty("java.io.tmpdir")), context);
    }

    private File asFile(Object fileattr) {
        if (fileattr == null) {
            return null;
        }
        if (fileattr instanceof File) {
            return (File)fileattr;
        }
        if (fileattr instanceof String) {
            return new File((String)fileattr);
        }
        if (fileattr instanceof Path) {
            return ((Path)fileattr).toFile();
        }
        return null;
    }

    public void makeTempDirectory(File parent, WebAppContext context) throws Exception {
        if (!(parent != null && parent.exists() && parent.canWrite() && parent.isDirectory())) {
            throw new IllegalStateException("Parent for temp dir not configured correctly: " + (parent == null ? "null" : "writeable=" + parent.canWrite()));
        }
        String temp = WebInfConfiguration.getCanonicalNameForWebAppTmpDir(context);
        File tmpDir = null;
        if (context.isPersistTempDirectory()) {
            tmpDir = new File(parent, temp);
            this.configureTempDirectory(tmpDir, context);
        } else {
            tmpDir = Files.createTempDirectory(parent.toPath(), temp, new FileAttribute[0]).toFile();
            tmpDir.deleteOnExit();
            this.ensureTempDirUsable(tmpDir);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set temp dir " + tmpDir, new Object[0]);
        }
        context.setTempDirectory(tmpDir);
    }

    public void configureTempDirectory(File dir, WebAppContext context) {
        if (dir == null) {
            throw new IllegalArgumentException("Null temp dir");
        }
        if (!context.isPersistTempDirectory() && dir.exists() && !IO.delete(dir)) {
            throw new IllegalStateException("Failed to delete temp dir " + dir);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Unable to create temp dir " + dir);
        }
        if (!context.isPersistTempDirectory()) {
            dir.deleteOnExit();
        }
        this.ensureTempDirUsable(dir);
    }

    private void ensureTempDirUsable(File dir) {
        if (!dir.canWrite() || !dir.isDirectory()) {
            throw new IllegalStateException("Temp dir " + dir + " not useable: writeable=" + dir.canWrite() + ", dir=" + dir.isDirectory());
        }
    }

    public void unpack(WebAppContext context) throws IOException {
        Resource webApp = context.getBaseResource();
        this._preUnpackBaseResource = context.getBaseResource();
        if (webApp == null) {
            Resource jarWebApp;
            String war = context.getWar();
            webApp = war != null && war.length() > 0 ? context.newResource(war) : context.getBaseResource();
            if (webApp == null) {
                throw new IllegalStateException("No resourceBase or war set for context");
            }
            if (webApp.isAlias()) {
                LOG.debug(webApp + " anti-aliased to " + webApp.getAlias(), new Object[0]);
                webApp = context.newResource(webApp.getAlias());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try webapp=" + webApp + ", exists=" + webApp.exists() + ", directory=" + webApp.isDirectory() + " file=" + webApp.getFile(), new Object[0]);
            }
            Resource originalWarResource = webApp;
            if (webApp.exists() && !webApp.isDirectory() && !webApp.toString().startsWith("jar:") && (jarWebApp = JarResource.newJarResource(webApp)).exists() && jarWebApp.isDirectory()) {
                webApp = jarWebApp;
            }
            if (webApp.exists() && (context.isCopyWebDir() && webApp.getFile() != null && webApp.getFile().isDirectory() || context.isExtractWAR() && webApp.getFile() != null && !webApp.getFile().isDirectory() || context.isExtractWAR() && webApp.getFile() == null || !webApp.isDirectory())) {
                File sibling;
                File warfile;
                File extractedWebAppDir = null;
                if (war != null && (warfile = Resource.newResource(war).getFile()) != null && warfile.getName().toLowerCase(Locale.ENGLISH).endsWith(".war") && (sibling = new File(warfile.getParent(), warfile.getName().substring(0, warfile.getName().length() - 4))).exists() && sibling.isDirectory() && sibling.canWrite()) {
                    extractedWebAppDir = sibling;
                }
                if (extractedWebAppDir == null) {
                    extractedWebAppDir = new File(context.getTempDirectory(), "webapp");
                }
                if (webApp.getFile() != null && webApp.getFile().isDirectory()) {
                    LOG.debug("Copy " + webApp + " to " + extractedWebAppDir, new Object[0]);
                    webApp.copyTo(extractedWebAppDir);
                } else {
                    Resource jarWebApp2;
                    File extractionLock = new File(context.getTempDirectory(), ".extract_lock");
                    if (!extractedWebAppDir.exists()) {
                        extractionLock.createNewFile();
                        extractedWebAppDir.mkdir();
                        LOG.debug("Extract " + webApp + " to " + extractedWebAppDir, new Object[0]);
                        jarWebApp2 = JarResource.newJarResource(webApp);
                        jarWebApp2.copyTo(extractedWebAppDir);
                        extractionLock.delete();
                    } else if (originalWarResource.lastModified() > extractedWebAppDir.lastModified() || extractionLock.exists()) {
                        extractionLock.createNewFile();
                        IO.delete(extractedWebAppDir);
                        extractedWebAppDir.mkdir();
                        LOG.debug("Extract " + webApp + " to " + extractedWebAppDir, new Object[0]);
                        jarWebApp2 = JarResource.newJarResource(webApp);
                        jarWebApp2.copyTo(extractedWebAppDir);
                        extractionLock.delete();
                    }
                }
                webApp = Resource.newResource(extractedWebAppDir.getCanonicalPath());
            }
            if (!webApp.exists() || !webApp.isDirectory()) {
                LOG.warn("Web application not found " + war, new Object[0]);
                throw new FileNotFoundException(war);
            }
            context.setBaseResource(webApp);
            if (LOG.isDebugEnabled()) {
                LOG.debug("webapp=" + webApp, new Object[0]);
            }
        }
        if (context.isCopyWebInf() && !context.isCopyWebDir()) {
            Resource webInfClasses;
            Resource webInf = webApp.addPath("WEB-INF/");
            File extractedWebInfDir = new File(context.getTempDirectory(), "webinf");
            if (extractedWebInfDir.exists()) {
                IO.delete(extractedWebInfDir);
            }
            extractedWebInfDir.mkdir();
            Resource webInfLib = webInf.addPath("lib/");
            File webInfDir = new File(extractedWebInfDir, "WEB-INF");
            webInfDir.mkdir();
            if (webInfLib.exists()) {
                File webInfLibDir = new File(webInfDir, "lib");
                if (webInfLibDir.exists()) {
                    IO.delete(webInfLibDir);
                }
                webInfLibDir.mkdir();
                LOG.debug("Copying WEB-INF/lib " + webInfLib + " to " + webInfLibDir, new Object[0]);
                webInfLib.copyTo(webInfLibDir);
            }
            if ((webInfClasses = webInf.addPath("classes/")).exists()) {
                File webInfClassesDir = new File(webInfDir, "classes");
                if (webInfClassesDir.exists()) {
                    IO.delete(webInfClassesDir);
                }
                webInfClassesDir.mkdir();
                LOG.debug("Copying WEB-INF/classes from " + webInfClasses + " to " + webInfClassesDir.getAbsolutePath(), new Object[0]);
                webInfClasses.copyTo(webInfClassesDir);
            }
            webInf = Resource.newResource(extractedWebInfDir.getCanonicalPath());
            ResourceCollection rc = new ResourceCollection(webInf, webApp);
            if (LOG.isDebugEnabled()) {
                LOG.debug("context.resourcebase = " + rc, new Object[0]);
            }
            context.setBaseResource(rc);
        }
    }

    public static String getCanonicalNameForWebAppTmpDir(WebAppContext context) {
        Connector[] connectors;
        StringBuffer canonicalName = new StringBuffer();
        canonicalName.append("jetty-");
        Server server = context.getServer();
        if (server != null && (connectors = context.getServer().getConnectors()).length > 0) {
            String host = null;
            int port = 0;
            if (connectors != null && connectors[0] instanceof NetworkConnector) {
                NetworkConnector connector = (NetworkConnector)connectors[0];
                host = connector.getHost();
                port = connector.getLocalPort();
                if (port < 0) {
                    port = connector.getPort();
                }
            }
            if (host == null) {
                host = "0.0.0.0";
            }
            canonicalName.append(host);
            canonicalName.append("-");
            canonicalName.append(port);
            canonicalName.append("-");
        }
        try {
            Resource resource = context.getBaseResource();
            if (resource == null) {
                if (context.getWar() == null || context.getWar().length() == 0) {
                    throw new IllegalStateException("No resourceBase or war set for context");
                }
                resource = context.newResource(context.getWar());
            }
            String resourceBaseName = WebInfConfiguration.getResourceBaseName(resource);
            canonicalName.append(resourceBaseName);
            canonicalName.append("-");
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Can't get resource base name", e);
            }
            canonicalName.append("-");
        }
        canonicalName.append(context.getContextPath());
        canonicalName.append("-");
        String[] vhosts = context.getVirtualHosts();
        if (vhosts == null || vhosts.length <= 0) {
            canonicalName.append("any");
        } else {
            canonicalName.append(vhosts[0]);
        }
        canonicalName.append("-");
        return StringUtil.sanitizeFileSystemName(canonicalName.toString());
    }

    protected static String getResourceBaseName(Resource resource) {
        URI uri;
        block6: {
            try {
                File resourceFile = resource.getFile();
                if (resourceFile != null && resource instanceof JarFileResource) {
                    resourceFile = ((JarFileResource)resource).getJarFile();
                }
                if (resourceFile != null) {
                    return resourceFile.getName();
                }
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("Resource has no File reference: {}", resource);
            }
        }
        if ((uri = resource.getURI()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource has no URI reference: {}", resource);
            }
            return "";
        }
        return URIUtil.getUriLastPathSegment(uri);
    }

    protected List<Resource> findClassDirs(WebAppContext context) throws Exception {
        List<Resource> extraClassDirs;
        if (context == null) {
            return null;
        }
        ArrayList<Resource> classDirs = new ArrayList<Resource>();
        Resource webInfClasses = this.findWebInfClassesDir(context);
        if (webInfClasses != null) {
            classDirs.add(webInfClasses);
        }
        if ((extraClassDirs = this.findExtraClasspathDirs(context)) != null) {
            classDirs.addAll(extraClassDirs);
        }
        return classDirs;
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        List<Resource> extraClasspathJars;
        ArrayList<Resource> jarResources = new ArrayList<Resource>();
        List<Resource> webInfLibJars = this.findWebInfLibJars(context);
        if (webInfLibJars != null) {
            jarResources.addAll(webInfLibJars);
        }
        if ((extraClasspathJars = this.findExtraClasspathJars(context)) != null) {
            jarResources.addAll(extraClasspathJars);
        }
        return jarResources;
    }

    protected List<Resource> findWebInfLibJars(WebAppContext context) throws Exception {
        Resource webInf = context.getWebInf();
        if (webInf == null || !webInf.exists()) {
            return null;
        }
        ArrayList<Resource> jarResources = new ArrayList<Resource>();
        Resource webInfLib = webInf.addPath("/lib");
        if (webInfLib.exists() && webInfLib.isDirectory()) {
            Object[] files = webInfLib.list();
            if (files != null) {
                Arrays.sort(files);
            }
            for (int f = 0; files != null && f < files.length; ++f) {
                try {
                    String extension;
                    Resource file = webInfLib.addPath((String)files[f]);
                    String fnlc = file.getName().toLowerCase(Locale.ENGLISH);
                    int dot = fnlc.lastIndexOf(46);
                    String string = extension = dot < 0 ? null : fnlc.substring(dot);
                    if (extension == null || !extension.equals(".jar") && !extension.equals(".zip")) continue;
                    jarResources.add(file);
                    continue;
                }
                catch (Exception ex) {
                    LOG.warn("EXCEPTION ", ex);
                }
            }
        }
        return jarResources;
    }

    protected List<Resource> findExtraClasspathJars(WebAppContext context) throws Exception {
        if (context == null || context.getExtraClasspath() == null) {
            return null;
        }
        ArrayList<Resource> jarResources = new ArrayList<Resource>();
        StringTokenizer tokenizer = new StringTokenizer(context.getExtraClasspath(), ",;");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (this.isGlobReference(token)) {
                Object[] entries;
                String dir = token.substring(0, token.length() - 2);
                Resource dirResource = context.newResource(dir);
                if (!dirResource.exists() || !dirResource.isDirectory() || (entries = dirResource.list()) == null) continue;
                Arrays.sort(entries);
                for (Object entry : entries) {
                    try {
                        Resource fileResource = dirResource.addPath((String)entry);
                        if (!this.isFileSupported(fileResource)) continue;
                        jarResources.add(fileResource);
                    }
                    catch (Exception ex) {
                        LOG.warn("EXCEPTION ", ex);
                    }
                }
                continue;
            }
            Resource resource = context.newResource(token);
            if (!this.isFileSupported(resource)) continue;
            jarResources.add(resource);
        }
        return jarResources;
    }

    protected Resource findWebInfClassesDir(WebAppContext context) throws Exception {
        Resource classes;
        if (context == null) {
            return null;
        }
        Resource webInf = context.getWebInf();
        if (webInf != null && webInf.isDirectory() && (classes = webInf.addPath("classes/")).exists()) {
            return classes;
        }
        return null;
    }

    protected List<Resource> findExtraClasspathDirs(WebAppContext context) throws Exception {
        if (context == null || context.getExtraClasspath() == null) {
            return null;
        }
        ArrayList<Resource> dirResources = new ArrayList<Resource>();
        StringTokenizer tokenizer = new StringTokenizer(context.getExtraClasspath(), ",;");
        while (tokenizer.hasMoreTokens()) {
            Resource resource;
            String token = tokenizer.nextToken().trim();
            if (this.isGlobReference(token) || !(resource = context.newResource(token)).exists() || !resource.isDirectory()) continue;
            dirResources.add(resource);
        }
        return dirResources;
    }

    private boolean isGlobReference(String token) {
        return token.endsWith("/*") || token.endsWith("\\*");
    }

    private boolean isFileSupported(Resource resource) {
        String filenameLowercase = resource.getName().toLowerCase(Locale.ENGLISH);
        int dot = filenameLowercase.lastIndexOf(46);
        String extension = dot < 0 ? null : filenameLowercase.substring(dot);
        return extension != null && (extension.equals(".jar") || extension.equals(".zip"));
    }

    public class WebAppPathNameMatcher
    extends PatternMatcher {
        protected final WebAppContext _context;
        protected final Pattern _pattern;

        public WebAppPathNameMatcher(WebAppContext context, Pattern pattern) {
            if (context == null) {
                throw new IllegalArgumentException("Context null");
            }
            this._context = context;
            this._pattern = pattern;
        }

        public void match(List<URI> uris) throws Exception {
            this.match(this._pattern, uris.toArray(new URI[uris.size()]), true);
        }

        @Override
        public void matched(URI uri) throws Exception {
            this._context.getMetaData().addWebInfJar(Resource.newResource(uri));
        }
    }

    public class ContainerPathNameMatcher
    extends PatternMatcher {
        protected final WebAppContext _context;
        protected final Pattern _pattern;

        public ContainerPathNameMatcher(WebAppContext context, Pattern pattern) {
            if (context == null) {
                throw new IllegalArgumentException("Context null");
            }
            this._context = context;
            this._pattern = pattern;
        }

        public void match(List<URI> uris) throws Exception {
            if (uris == null) {
                return;
            }
            this.match(this._pattern, uris.toArray(new URI[uris.size()]), false);
        }

        @Override
        public void matched(URI uri) throws Exception {
            this._context.getMetaData().addContainerResource(Resource.newResource(uri));
        }
    }
}

