/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.ssl;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSource;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.util.Objects;

public class ReadOnlyFileOrClasspathKeyStoreSource
extends KeyStoreSource {
    protected final String path;

    public ReadOnlyFileOrClasspathKeyStoreSource(String path2, String keyStoreType, char[] keyStorePassword) {
        super(keyStoreType, keyStorePassword);
        this.path = path2;
    }

    @Override
    protected InputStream createInputStream() {
        try {
            if (this.exists()) {
                return new FileInputStream(this.path);
            }
            try {
                URL pathUrl = new URL(this.path);
                return pathUrl.openStream();
            }
            catch (MalformedURLException ignored) {
                return Resources.getResource(this.path).openStream();
            }
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, InputStream.class);
        }
    }

    @Override
    public boolean exists() {
        return new File(this.path).isFile();
    }

    @Override
    public void save(KeyStore keyStore) {
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReadOnlyFileOrClasspathKeyStoreSource that = (ReadOnlyFileOrClasspathKeyStoreSource)o;
        return this.path.equals(that.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path);
    }
}

