/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.ssl;

import com.github.tomakehurst.wiremock.common.Source;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSource;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSourceFactory;
import com.github.tomakehurst.wiremock.common.ssl.ReadOnlyFileOrClasspathKeyStoreSource;
import java.security.KeyStore;

public class KeyStoreSettings {
    public static final KeyStoreSettings NO_STORE = new KeyStoreSettings(null, null, null);
    private final KeyStoreSource keyStoreSource;

    public KeyStoreSettings(KeyStoreSource keyStoreSource) {
        this.keyStoreSource = keyStoreSource;
    }

    public KeyStoreSettings(String path2, String password, String type) {
        this(path2 != null && password != null && type != null ? KeyStoreSourceFactory.getAppropriateForJreVersion(path2, type, password.toCharArray()) : null);
    }

    public String path() {
        if (this.keyStoreSource instanceof ReadOnlyFileOrClasspathKeyStoreSource) {
            return ((ReadOnlyFileOrClasspathKeyStoreSource)this.keyStoreSource).getPath();
        }
        return "(no path - custom keystore source)";
    }

    public String password() {
        return this.keyStoreSource.getKeyStorePassword();
    }

    public String type() {
        return this.keyStoreSource.getKeyStoreType();
    }

    public KeyStore loadStore() {
        return this.keyStoreSource.load();
    }

    public Source<KeyStore> getSource() {
        return this.keyStoreSource;
    }

    public boolean exists() {
        return this.keyStoreSource.exists();
    }
}

