/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.retry;

import java.time.Duration;
import java.util.function.Function;
import reactivefeign.retry.ReactiveRetryPolicy;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.util.function.Tuples;
import reactor.util.retry.Retry;

public abstract class SimpleReactiveRetryPolicy
implements ReactiveRetryPolicy {
    private final Scheduler scheduler;

    protected SimpleReactiveRetryPolicy(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public abstract long retryDelay(Throwable var1, int var2);

    @Override
    public Function<Flux<Retry.RetrySignal>, Flux<Throwable>> toRetryFunction() {
        return errors -> errors.zipWith(Flux.range(1, Integer.MAX_VALUE), (signal, index) -> {
            long delay = this.retryDelay(signal.failure(), (int)index);
            if (delay >= 0L) {
                return Tuples.of(delay, signal);
            }
            throw Exceptions.propagate(signal.failure());
        }).concatMap(tuple2 -> (Long)tuple2.getT1() > 0L ? Mono.delay(Duration.ofMillis((Long)tuple2.getT1()), this.scheduler).map(time -> ((Retry.RetrySignal)tuple2.getT2()).failure()) : Mono.just(((Retry.RetrySignal)tuple2.getT2()).failure()));
    }
}

