/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.publisher.retry;

import feign.MethodMetadata;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactivefeign.client.ReactiveFeignException;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.publisher.retry.OutOfRetriesException;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public abstract class RetryPublisherHttpClient
implements PublisherHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(RetryPublisherHttpClient.class);
    private final String feignMethodKey;
    protected final PublisherHttpClient publisherClient;
    protected final Function<Flux<Retry.RetrySignal>, Flux<Throwable>> retryFunction;

    protected RetryPublisherHttpClient(PublisherHttpClient publisherClient, MethodMetadata methodMetadata, Function<Flux<Retry.RetrySignal>, Flux<Throwable>> retryFunction) {
        this.publisherClient = publisherClient;
        this.feignMethodKey = methodMetadata.configKey();
        this.retryFunction = RetryPublisherHttpClient.wrapWithLog(retryFunction, this.feignMethodKey);
    }

    protected Function<Flux<Retry.RetrySignal>, Flux<Throwable>> wrapWithOutOfRetries(Function<Flux<Retry.RetrySignal>, Flux<Throwable>> retryFunction, ReactiveHttpRequest request) {
        return signalFlux -> ((Flux)retryFunction.apply((Flux<Retry.RetrySignal>)signalFlux)).onErrorResume(throwable -> Mono.just(new OutOfRetriesWrapper((Throwable)throwable, request))).zipWith(Flux.range(1, Integer.MAX_VALUE), (throwable, index) -> {
            if (throwable instanceof OutOfRetriesWrapper) {
                if (index == 1) {
                    throw Exceptions.propagate(throwable.getCause());
                }
                logger.debug("[{}]---> USED ALL RETRIES", (Object)this.feignMethodKey, throwable);
                throw Exceptions.propagate(new OutOfRetriesException(throwable.getCause(), request));
            }
            return throwable;
        });
    }

    protected static Function<Flux<Retry.RetrySignal>, Flux<Throwable>> wrapWithLog(Function<Flux<Retry.RetrySignal>, Flux<Throwable>> retryFunction, String feignMethodTag) {
        return throwableFlux -> ((Flux)retryFunction.apply((Flux<Retry.RetrySignal>)throwableFlux)).doOnNext(throwable -> {
            if (logger.isDebugEnabled()) {
                logger.debug("[{}]---> RETRYING on error", (Object)feignMethodTag, throwable);
            }
        });
    }

    private static class OutOfRetriesWrapper
    extends ReactiveFeignException {
        public OutOfRetriesWrapper(Throwable cause, ReactiveHttpRequest request) {
            super(cause, request);
        }
    }
}

