/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.client;

import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ReactorNettyWebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.WebsocketClientSpec;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

public class ReactorNettyWebSocketClient
implements WebSocketClient {
    private static final Log logger = LogFactory.getLog(ReactorNettyWebSocketClient.class);
    private final HttpClient httpClient;
    private final Supplier<WebsocketClientSpec.Builder> specBuilderSupplier;
    @Nullable
    private Integer maxFramePayloadLength;
    @Nullable
    private Boolean handlePing;

    public ReactorNettyWebSocketClient() {
        this(HttpClient.create());
    }

    public ReactorNettyWebSocketClient(HttpClient httpClient) {
        this(httpClient, WebsocketClientSpec.builder());
    }

    public ReactorNettyWebSocketClient(HttpClient httpClient, Supplier<WebsocketClientSpec.Builder> builderSupplier) {
        Assert.notNull((Object)httpClient, "HttpClient is required");
        Assert.notNull(builderSupplier, "WebsocketClientSpec.Builder is required");
        this.httpClient = httpClient;
        this.specBuilderSupplier = builderSupplier;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public WebsocketClientSpec getWebsocketClientSpec() {
        return this.buildSpec(null);
    }

    private WebsocketClientSpec buildSpec(@Nullable String protocols) {
        WebsocketClientSpec.Builder builder = this.specBuilderSupplier.get();
        if (StringUtils.hasText(protocols)) {
            builder.protocols(protocols);
        }
        if (this.maxFramePayloadLength != null) {
            builder.maxFramePayloadLength(this.maxFramePayloadLength);
        }
        if (this.handlePing != null) {
            builder.handlePing(this.handlePing);
        }
        return builder.build();
    }

    @Deprecated
    public void setMaxFramePayloadLength(int maxFramePayloadLength) {
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    @Deprecated
    public int getMaxFramePayloadLength() {
        return this.getWebsocketClientSpec().maxFramePayloadLength();
    }

    @Deprecated
    public void setHandlePing(boolean handlePing) {
        this.handlePing = handlePing;
    }

    @Deprecated
    public boolean getHandlePing() {
        return this.getWebsocketClientSpec().handlePing();
    }

    @Override
    public Mono<Void> execute(URI url, WebSocketHandler handler) {
        return this.execute(url, new HttpHeaders(), handler);
    }

    @Override
    public Mono<Void> execute(URI url, HttpHeaders requestHeaders, WebSocketHandler handler) {
        String protocols = StringUtils.collectionToCommaDelimitedString(handler.getSubProtocols());
        return ((HttpClient.WebsocketSender)this.getHttpClient().headers(nettyHeaders -> this.setNettyHeaders(requestHeaders, (io.netty.handler.codec.http.HttpHeaders)nettyHeaders)).websocket(this.buildSpec(protocols)).uri(url.toString())).handle((inbound, outbound) -> {
            HttpHeaders responseHeaders = this.toHttpHeaders((WebsocketInbound)inbound);
            String protocol = responseHeaders.getFirst("Sec-WebSocket-Protocol");
            HandshakeInfo info = new HandshakeInfo(url, responseHeaders, Mono.empty(), protocol);
            NettyDataBufferFactory factory = new NettyDataBufferFactory(outbound.alloc());
            ReactorNettyWebSocketSession session = new ReactorNettyWebSocketSession((WebsocketInbound)inbound, (WebsocketOutbound)outbound, info, factory, this.getMaxFramePayloadLength());
            if (logger.isDebugEnabled()) {
                logger.debug("Started session '" + session.getId() + "' for " + url);
            }
            return handler.handle(session).checkpoint(url + " [ReactorNettyWebSocketClient]");
        }).doOnRequest(n -> {
            if (logger.isDebugEnabled()) {
                logger.debug("Connecting to " + url);
            }
        }).next();
    }

    private void setNettyHeaders(HttpHeaders httpHeaders, io.netty.handler.codec.http.HttpHeaders nettyHeaders) {
        httpHeaders.forEach((BiConsumer<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, set(java.lang.String java.lang.Iterable ), (Ljava/lang/String;Ljava/util/List;)V)((io.netty.handler.codec.http.HttpHeaders)nettyHeaders));
    }

    private HttpHeaders toHttpHeaders(WebsocketInbound inbound) {
        HttpHeaders headers2 = new HttpHeaders();
        io.netty.handler.codec.http.HttpHeaders nettyHeaders = inbound.headers();
        nettyHeaders.forEach(entry -> {
            String name = (String)entry.getKey();
            headers2.put(name, nettyHeaders.getAll(name));
        });
        return headers2;
    }
}

