/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign;

import feign.Contract;
import feign.MethodMetadata;
import feign.Util;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import reactivefeign.utils.FeignUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveContract
implements Contract {
    private final Contract delegate;
    private static final Set<Class> REACTOR_PUBLISHERS = new HashSet<Class>(Arrays.asList(Mono.class, Flux.class));

    public ReactiveContract(Contract delegate) {
        this.delegate = Util.checkNotNull(delegate, "delegate must not be null", new Object[0]);
    }

    @Override
    public List<MethodMetadata> parseAndValidateMetadata(Class<?> targetType) {
        List<MethodMetadata> methodsMetadata = this.delegate.parseAndValidateMetadata(targetType);
        for (MethodMetadata metadata : methodsMetadata) {
            Type type = metadata.returnType();
            if (!this.isReactorType(type)) {
                throw new IllegalArgumentException(String.format("Method %s of contract %s doesn't returns reactor.core.publisher.Mono or reactor.core.publisher.Flux", metadata.configKey(), targetType.getSimpleName()));
            }
            if (FeignUtils.returnActualType(metadata) != byte[].class && FeignUtils.bodyActualType(metadata) != byte[].class) continue;
            throw new IllegalArgumentException(String.format("Method %s of contract %s will cause data to be copied, use ByteBuffer instead", metadata.configKey(), targetType.getSimpleName()));
        }
        return methodsMetadata;
    }

    private boolean isReactorType(Type type) {
        return type instanceof ParameterizedType && REACTOR_PUBLISHERS.contains(FeignUtils.returnPublisherType(type));
    }
}

