/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import io.netty.handler.timeout.ReadTimeoutException;
import java.util.function.BiFunction;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import reactivefeign.ReactiveOptions;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.webclient.CoreWebBuilder;
import reactivefeign.webclient.NettyClientHttpConnectorBuilder;
import reactivefeign.webclient.WebClientFeignCustomizer;
import reactivefeign.webclient.WebReactiveOptions;

public class WebReactiveFeign {
    public static <T> Builder<T> builder() {
        return WebReactiveFeign.builder(WebClient.builder());
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder) {
        return new Builder(webClientBuilder);
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
        return new Builder(webClientBuilder, webClientCustomizer);
    }

    public static class Builder<T>
    extends CoreWebBuilder<T> {
        protected Builder(WebClient.Builder webClientBuilder) {
            super(webClientBuilder);
        }

        protected Builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
            super(webClientBuilder, webClientCustomizer);
        }

        @Override
        public Builder<T> options(ReactiveOptions options) {
            this.webClientBuilder.clientConnector(NettyClientHttpConnectorBuilder.buildNettyClientHttpConnector((WebReactiveOptions)options));
            this.updateClientFactory();
            return this;
        }

        @Override
        protected ClientHttpConnector buildClientConnector() {
            return NettyClientHttpConnectorBuilder.buildNettyClientHttpConnector(WebReactiveOptions.DEFAULT_OPTIONS);
        }

        @Override
        public BiFunction<ReactiveHttpRequest, Throwable, Throwable> errorMapper() {
            return (request, throwable) -> {
                if (throwable instanceof WebClientRequestException && throwable.getCause() instanceof ReadTimeoutException) {
                    return new reactivefeign.client.ReadTimeoutException((Throwable)throwable, (ReactiveHttpRequest)request);
                }
                return null;
            };
        }
    }
}

