/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.internal.AbstractEventPublisher;

public class RequestEventPublisher
extends AbstractEventPublisher<ReactiveRequest.Event>
implements Request.Listener {
    private final ReactiveRequest request;

    public RequestEventPublisher(ReactiveRequest request) {
        this.request = request;
    }

    @Override
    public void onQueued(Request request) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.QUEUED, this.request));
    }

    @Override
    public void onBegin(Request request) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.BEGIN, this.request));
    }

    @Override
    public void onHeaders(Request request) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.HEADERS, this.request));
    }

    @Override
    public void onCommit(Request request) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.COMMIT, this.request));
    }

    @Override
    public void onContent(Request request, ByteBuffer content) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.CONTENT, this.request, content));
    }

    @Override
    public void onSuccess(Request request) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.SUCCESS, this.request));
        this.succeed();
    }

    @Override
    public void onFailure(Request request, Throwable failure) {
        this.emit(new ReactiveRequest.Event(ReactiveRequest.Event.Type.FAILURE, this.request, failure));
        this.fail(failure);
    }
}

