/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

class PathUtils {
    private static final Pattern ENCODED_TILDA_PATTERN = Pattern.compile("~");
    private static final Pattern ENCODED_SLASH_PATTERN = Pattern.compile("/");
    private static final Pattern DECODED_TILDA_PATTERN = Pattern.compile("~0");
    private static final Pattern DECODED_SLASH_PATTERN = Pattern.compile("~1");

    PathUtils() {
    }

    private static String encodePath(Object object) {
        String path2 = object.toString();
        path2 = ENCODED_TILDA_PATTERN.matcher(path2).replaceAll("~0");
        return ENCODED_SLASH_PATTERN.matcher(path2).replaceAll("~1");
    }

    private static String decodePath(Object object) {
        String path2 = object.toString();
        path2 = DECODED_TILDA_PATTERN.matcher(path2).replaceAll("~");
        return DECODED_SLASH_PATTERN.matcher(path2).replaceAll("/");
    }

    static <T> String getPathRepresentation(List<T> path2) {
        StringBuilder builder = new StringBuilder();
        builder.append('/');
        int count = 0;
        for (T o : path2) {
            if (++count > 1) {
                builder.append('/');
            }
            builder.append(PathUtils.encodePath(o));
        }
        return builder.toString();
    }

    static List<String> getPath(JsonNode path2) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        String cleanPath = path2.toString().replaceAll("\"", "");
        for (int index = 0; index < cleanPath.length(); ++index) {
            char c = cleanPath.charAt(index);
            if (c == '/') {
                result.add(PathUtils.decodePath(builder.toString()));
                builder.delete(0, builder.length());
                continue;
            }
            builder.append(c);
        }
        result.add(PathUtils.decodePath(builder.toString()));
        return result;
    }
}

