/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.xmlunit.util.Mapper;
import org.xmlunit.util.Predicate;

public final class Linqy {
    private Linqy() {
    }

    public static <E> List<E> asList(Iterable<E> i2) {
        if (i2 instanceof Collection) {
            return new ArrayList((Collection)i2);
        }
        ArrayList<E> a = new ArrayList<E>();
        for (E e : i2) {
            a.add(e);
        }
        return a;
    }

    public static <E> Iterable<E> cast(Iterable i2) {
        return Linqy.map(i2, new Mapper<Object, E>(){

            @Override
            public E apply(Object o) {
                return o;
            }
        });
    }

    public static <E> Iterable<E> singleton(final E single) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new OnceOnlyIterator(single);
            }
        };
    }

    public static <F, T> Iterable<T> map(final Iterable<F> from, final Mapper<? super F, T> mapper) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new MappingIterator(from.iterator(), mapper);
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> sequence, final Predicate<? super T> filter2) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new FilteringIterator(sequence.iterator(), filter2);
            }
        };
    }

    public static int count(Iterable seq) {
        if (seq instanceof Collection) {
            return ((Collection)seq).size();
        }
        int c = 0;
        Iterator it = seq.iterator();
        while (it.hasNext()) {
            ++c;
            it.next();
        }
        return c;
    }

    public static <T> boolean any(Iterable<T> sequence, Predicate<? super T> predicate) {
        for (T t : sequence) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean all(Iterable<T> sequence, Predicate<? super T> predicate) {
        for (T t : sequence) {
            if (predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    private static class FilteringIterator<T>
    implements Iterator<T> {
        private final Iterator<T> i;
        private final Predicate<? super T> filter;
        private T lookAhead = null;

        private FilteringIterator(Iterator<T> i2, Predicate<? super T> filter2) {
            this.i = i2;
            this.filter = filter2;
            this.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public T next() {
            if (this.lookAhead == null) {
                throw new NoSuchElementException();
            }
            T next = this.lookAhead;
            this.lookAhead = null;
            return next;
        }

        @Override
        public boolean hasNext() {
            while (this.lookAhead == null && this.i.hasNext()) {
                T next = this.i.next();
                if (!this.filter.test(next)) continue;
                this.lookAhead = next;
            }
            return this.lookAhead != null;
        }
    }

    private static class MappingIterator<F, T>
    implements Iterator<T> {
        private final Iterator<F> i;
        private final Mapper<? super F, T> mapper;

        private MappingIterator(Iterator<F> i2, Mapper<? super F, T> mapper) {
            this.i = i2;
            this.mapper = mapper;
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public T next() {
            return this.mapper.apply(this.i.next());
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }
    }

    private static class OnceOnlyIterator<E>
    implements Iterator<E> {
        private final E element;
        private boolean iterated = false;

        private OnceOnlyIterator(E element) {
            this.element = element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E next() {
            if (this.iterated) {
                throw new NoSuchElementException();
            }
            this.iterated = true;
            return this.element;
        }

        @Override
        public boolean hasNext() {
            return !this.iterated;
        }
    }
}

