/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.ssl;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSource;
import com.github.tomakehurst.wiremock.common.ssl.ReadOnlyFileOrClasspathKeyStoreSource;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class KeyStoreSourceFactory {
    public static KeyStoreSource getAppropriateForJreVersion(String path2, String keyStoreType, char[] keyStorePassword) {
        try {
            Class<?> theClass = Class.forName("com.github.tomakehurst.wiremock.jetty94.WritableFileOrClasspathKeyStoreSource");
            return (KeyStoreSource)KeyStoreSourceFactory.safelyGetConstructor(theClass, String.class, String.class, char[].class).newInstance(path2, keyStoreType, keyStorePassword);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return new ReadOnlyFileOrClasspathKeyStoreSource(path2, keyStoreType, keyStorePassword);
        }
    }

    private static <T> Constructor<T> safelyGetConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return Exceptions.throwUnchecked(e, Constructor.class);
        }
    }
}

