/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.multipart;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.MultipartUtils;
import org.springframework.http.codec.multipart.Part;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class DefaultParts {
    DefaultParts() {
    }

    public static FormFieldPart formFieldPart(HttpHeaders headers2, String value) {
        Assert.notNull((Object)headers2, "Headers must not be null");
        Assert.notNull((Object)value, "Value must not be null");
        return new DefaultFormFieldPart(headers2, value);
    }

    public static Part part(HttpHeaders headers2, Flux<DataBuffer> content) {
        Assert.notNull((Object)headers2, "Headers must not be null");
        Assert.notNull(content, "Content must not be null");
        String filename = headers2.getContentDisposition().getFilename();
        if (filename != null) {
            return new DefaultFilePart(headers2, content);
        }
        return new DefaultPart(headers2, content);
    }

    private static class DefaultFilePart
    extends DefaultPart
    implements FilePart {
        public DefaultFilePart(HttpHeaders headers2, Flux<DataBuffer> content) {
            super(headers2, content);
        }

        @Override
        public String filename() {
            String filename = this.headers().getContentDisposition().getFilename();
            Assert.state(filename != null, "No filename found");
            return filename;
        }

        @Override
        public Mono<Void> transferTo(Path dest) {
            return DataBufferUtils.write(this.content(), dest, new OpenOption[0]);
        }

        @Override
        public String toString() {
            ContentDisposition contentDisposition = this.headers().getContentDisposition();
            String name = contentDisposition.getName();
            String filename = contentDisposition.getFilename();
            if (name != null) {
                return "DefaultFilePart{" + this.name() + " (" + filename + ")}";
            }
            return "DefaultFilePart{(" + filename + ")}";
        }
    }

    private static class DefaultPart
    extends AbstractPart {
        private final Flux<DataBuffer> content;

        public DefaultPart(HttpHeaders headers2, Flux<DataBuffer> content) {
            super(headers2);
            this.content = content;
        }

        @Override
        public Flux<DataBuffer> content() {
            return this.content;
        }

        public String toString() {
            String name = this.headers().getContentDisposition().getName();
            if (name != null) {
                return "DefaultPart{" + name + "}";
            }
            return "DefaultPart";
        }
    }

    private static class DefaultFormFieldPart
    extends AbstractPart
    implements FormFieldPart {
        private final String value;

        public DefaultFormFieldPart(HttpHeaders headers2, String value) {
            super(headers2);
            this.value = value;
        }

        @Override
        public Flux<DataBuffer> content() {
            return Flux.defer(() -> {
                byte[] bytes = this.value.getBytes(MultipartUtils.charset(this.headers()));
                return Flux.just(DefaultDataBufferFactory.sharedInstance.wrap(bytes));
            });
        }

        @Override
        public String value() {
            return this.value;
        }

        public String toString() {
            String name = this.headers().getContentDisposition().getName();
            if (name != null) {
                return "DefaultFormFieldPart{" + this.name() + "}";
            }
            return "DefaultFormFieldPart";
        }
    }

    private static abstract class AbstractPart
    implements Part {
        private final HttpHeaders headers;

        protected AbstractPart(HttpHeaders headers2) {
            Assert.notNull((Object)headers2, "HttpHeaders is required");
            this.headers = headers2;
        }

        @Override
        public String name() {
            String name = this.headers().getContentDisposition().getName();
            Assert.state(name != null, "No name available");
            return name;
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }
    }
}

