/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestLine;
import com.github.tomakehurst.wiremock.extension.responsetemplating.UrlPath;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;

public class RequestTemplateModel {
    private final RequestLine requestLine;
    private final Map<String, ListOrSingle<String>> headers;
    private final Map<String, ListOrSingle<String>> cookies;
    private final String body;

    protected RequestTemplateModel(RequestLine requestLine, Map<String, ListOrSingle<String>> headers2, Map<String, ListOrSingle<String>> cookies, String body2) {
        this.requestLine = requestLine;
        this.headers = headers2;
        this.cookies = cookies;
        this.body = body2;
    }

    public static RequestTemplateModel from(final Request request) {
        RequestLine requestLine = RequestLine.fromRequest(request);
        TreeMap<String, ListOrSingle<String>> adaptedHeaders = new TreeMap<String, ListOrSingle<String>>(String.CASE_INSENSITIVE_ORDER);
        adaptedHeaders.putAll(Maps.toMap(request.getAllHeaderKeys(), new Function<String, ListOrSingle<String>>(){

            @Override
            public ListOrSingle<String> apply(String input) {
                return ListOrSingle.of(request.header(input).values());
            }
        }));
        Map<String, ListOrSingle<String>> adaptedCookies = Maps.transformValues(request.getCookies(), new Function<Cookie, ListOrSingle<String>>(){

            @Override
            public ListOrSingle<String> apply(Cookie cookie) {
                return ListOrSingle.of(cookie.getValues());
            }
        });
        return new RequestTemplateModel(requestLine, adaptedHeaders, adaptedCookies, request.getBodyAsString());
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public RequestMethod getMethod() {
        return this.requestLine.getMethod();
    }

    public UrlPath getPathSegments() {
        return this.requestLine.getPathSegments();
    }

    public UrlPath getPath() {
        return this.requestLine.getPathSegments();
    }

    public String getUrl() {
        return this.requestLine.getUrl();
    }

    public Map<String, ListOrSingle<String>> getQuery() {
        return this.requestLine.getQuery();
    }

    public String getScheme() {
        return this.requestLine.getScheme();
    }

    public String getHost() {
        return this.requestLine.getHost();
    }

    public int getPort() {
        return this.requestLine.getPort();
    }

    public String getBaseUrl() {
        return this.requestLine.getBaseUrl();
    }

    public Map<String, ListOrSingle<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, ListOrSingle<String>> getCookies() {
        return this.cookies;
    }

    public String getBody() {
        return this.body;
    }
}

