/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieEncoderUtil;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.HttpHeaderDateFormat;
import java.text.ParsePosition;
import java.util.Date;

public final class ClientCookieDecoder {
    public static Cookie decode(String header) {
        char c;
        if (header == null) {
            throw new NullPointerException("header");
        }
        int headerLen = header.length();
        if (headerLen == 0) {
            return null;
        }
        CookieBuilder cookieBuilder = null;
        int i2 = 0;
        while (i2 != headerLen && (c = header.charAt(i2)) != ',') {
            String value;
            String rawValue;
            int newNameEnd;
            int newNameStart;
            block18: {
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ';') {
                    ++i2;
                    continue;
                }
                newNameStart = i2;
                newNameEnd = i2;
                if (i2 == headerLen) {
                    rawValue = null;
                    value = null;
                } else {
                    do {
                        char curChar;
                        if ((curChar = header.charAt(i2)) == ';') {
                            newNameEnd = i2;
                            rawValue = null;
                            value = null;
                            break block18;
                        }
                        if (curChar != '=') continue;
                        newNameEnd = i2++;
                        if (i2 == headerLen) {
                            rawValue = "";
                            value = "";
                            break block18;
                        }
                        int newValueStart = i2;
                        char c2 = header.charAt(i2);
                        if (c2 == '\"') {
                            StringBuilder newValueBuf = CookieEncoderUtil.stringBuilder();
                            int rawValueStart = i2;
                            int rawValueEnd = i2++;
                            char q = c2;
                            boolean hadBackslash = false;
                            while (true) {
                                if (i2 == headerLen) {
                                    value = newValueBuf.toString();
                                    rawValue = header.substring(rawValueStart, rawValueEnd);
                                    break block18;
                                }
                                if (hadBackslash) {
                                    hadBackslash = false;
                                    c2 = header.charAt(i2++);
                                    rawValueEnd = i2;
                                    if (c2 == '\\' || c2 == '\"') {
                                        newValueBuf.setCharAt(newValueBuf.length() - 1, c2);
                                        continue;
                                    }
                                    newValueBuf.append(c2);
                                    continue;
                                }
                                c2 = header.charAt(i2++);
                                rawValueEnd = i2;
                                if (c2 == q) {
                                    value = newValueBuf.toString();
                                    rawValue = header.substring(rawValueStart, rawValueEnd);
                                    break block18;
                                }
                                newValueBuf.append(c2);
                                if (c2 != '\\') continue;
                                hadBackslash = true;
                            }
                        }
                        int semiPos = header.indexOf(59, i2);
                        if (semiPos > 0) {
                            value = rawValue = header.substring(newValueStart, semiPos);
                            i2 = semiPos;
                        } else {
                            value = rawValue = header.substring(newValueStart);
                            i2 = headerLen;
                        }
                        break block18;
                    } while (++i2 != headerLen);
                    newNameEnd = i2;
                    rawValue = null;
                    value = null;
                }
            }
            if (cookieBuilder == null) {
                cookieBuilder = new CookieBuilder(header, newNameStart, newNameEnd, value, rawValue);
                continue;
            }
            cookieBuilder.appendAttribute(header, newNameStart, newNameEnd, value);
        }
        return cookieBuilder.cookie();
    }

    private ClientCookieDecoder() {
    }

    private static class CookieBuilder {
        private final String name;
        private final String value;
        private final String rawValue;
        private String domain;
        private String path;
        private long maxAge = Long.MIN_VALUE;
        private String expires;
        private boolean secure;
        private boolean httpOnly;

        public CookieBuilder(String header, int keyStart, int keyEnd, String value, String rawValue) {
            this.name = header.substring(keyStart, keyEnd);
            this.value = value;
            this.rawValue = rawValue;
        }

        private long mergeMaxAgeAndExpire(long maxAge, String expires) {
            Date expiresDate;
            if (maxAge != Long.MIN_VALUE) {
                return maxAge;
            }
            if (expires != null && (expiresDate = HttpHeaderDateFormat.get().parse(expires, new ParsePosition(0))) != null) {
                long maxAgeMillis = expiresDate.getTime() - System.currentTimeMillis();
                return maxAgeMillis / 1000L + (long)(maxAgeMillis % 1000L != 0L ? 1 : 0);
            }
            return Long.MIN_VALUE;
        }

        public Cookie cookie() {
            if (this.name == null) {
                return null;
            }
            DefaultCookie cookie = new DefaultCookie(this.name, this.value);
            cookie.setValue(this.value);
            cookie.setRawValue(this.rawValue);
            cookie.setDomain(this.domain);
            cookie.setPath(this.path);
            cookie.setMaxAge(this.mergeMaxAgeAndExpire(this.maxAge, this.expires));
            cookie.setSecure(this.secure);
            cookie.setHttpOnly(this.httpOnly);
            return cookie;
        }

        public void appendAttribute(String header, int keyStart, int keyEnd, String value) {
            this.setCookieAttribute(header, keyStart, keyEnd, value);
        }

        private void setCookieAttribute(String header, int keyStart, int keyEnd, String value) {
            int length = keyEnd - keyStart;
            if (length == 4) {
                this.parse4(header, keyStart, value);
            } else if (length == 6) {
                this.parse6(header, keyStart, value);
            } else if (length == 7) {
                this.parse7(header, keyStart, value);
            } else if (length == 8) {
                this.parse8(header, keyStart, value);
            }
        }

        private void parse4(String header, int nameStart, String value) {
            if (header.regionMatches(true, nameStart, "Path", 0, 4)) {
                this.path = value;
            }
        }

        private void parse6(String header, int nameStart, String value) {
            if (header.regionMatches(true, nameStart, "Domain", 0, 5)) {
                this.domain = value.isEmpty() ? null : value;
            } else if (header.regionMatches(true, nameStart, "Secure", 0, 5)) {
                this.secure = true;
            }
        }

        private void setExpire(String value) {
            this.expires = value;
        }

        private void setMaxAge(String value) {
            try {
                this.maxAge = Math.max(Long.valueOf(value), 0L);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private void parse7(String header, int nameStart, String value) {
            if (header.regionMatches(true, nameStart, "Expires", 0, 7)) {
                this.setExpire(value);
            } else if (header.regionMatches(true, nameStart, "Max-Age", 0, 7)) {
                this.setMaxAge(value);
            }
        }

        private void parse8(String header, int nameStart, String value) {
            if (header.regionMatches(true, nameStart, "HttpOnly", 0, 8)) {
                this.httpOnly = true;
            }
        }
    }
}

