/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.reactive.result.method.annotation.ModelInitializer;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class ModelAttributeMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    private final boolean useDefaultResolution;

    public ModelAttributeMethodArgumentResolver(ReactiveAdapterRegistry adapterRegistry, boolean useDefaultResolution) {
        super(adapterRegistry);
        this.useDefaultResolution = useDefaultResolution;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(ModelAttribute.class)) {
            return true;
        }
        if (this.useDefaultResolution) {
            return this.checkParameterType(parameter, type -> !BeanUtils.isSimpleProperty(type));
        }
        return false;
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext context, ServerWebExchange exchange2) {
        ResolvableType type = ResolvableType.forMethodParameter(parameter);
        Class<?> resolvedType = type.resolve();
        ReactiveAdapter adapter = resolvedType != null ? this.getAdapterRegistry().getAdapter(resolvedType) : null;
        ResolvableType valueType = adapter != null ? type.getGeneric(new int[0]) : type;
        Assert.state(adapter == null || !adapter.isMultiValue(), () -> this.getClass().getSimpleName() + " does not support multi-value reactive type wrapper: " + parameter.getGenericParameterType());
        String name = ModelInitializer.getNameForParameter(parameter);
        Mono<?> valueMono = this.prepareAttributeMono(name, valueType, context, exchange2);
        Sinks.One bindingResultSink = Sinks.unsafe().one();
        Map model = context.getModel().asMap();
        model.put(BindingResult.MODEL_KEY_PREFIX + name, bindingResultSink.asMono());
        return valueMono.flatMap(value -> {
            WebExchangeDataBinder binder = context.createDataBinder(exchange2, value, name);
            return this.bindRequestParameters(binder, exchange2).doOnError(bindingResultSink::tryEmitError).doOnSuccess(aVoid -> {
                this.validateIfApplicable(binder, parameter);
                BindingResult bindingResult = binder.getBindingResult();
                model.put(BindingResult.MODEL_KEY_PREFIX + name, bindingResult);
                model.put(name, value);
                bindingResultSink.tryEmitValue(bindingResult);
            }).then(Mono.fromCallable(() -> {
                BindingResult errors = binder.getBindingResult();
                if (adapter != null) {
                    return adapter.fromPublisher(errors.hasErrors() ? Mono.error(new WebExchangeBindException(parameter, errors)) : valueMono);
                }
                if (errors.hasErrors() && !this.hasErrorsArgument(parameter)) {
                    throw new WebExchangeBindException(parameter, errors);
                }
                return value;
            }));
        });
    }

    protected Mono<Void> bindRequestParameters(WebExchangeDataBinder binder, ServerWebExchange exchange2) {
        return binder.bind(exchange2);
    }

    private Mono<?> prepareAttributeMono(String attributeName, ResolvableType attributeType, BindingContext context, ServerWebExchange exchange2) {
        Object attribute = context.getModel().asMap().get(attributeName);
        if (attribute == null) {
            attribute = this.findAndRemoveReactiveAttribute(context.getModel(), attributeName);
        }
        if (attribute == null) {
            return this.createAttribute(attributeName, attributeType.toClass(), context, exchange2);
        }
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(null, attribute);
        if (adapter != null) {
            Assert.isTrue(!adapter.isMultiValue(), "Data binding only supports single-value async types");
            return Mono.from(adapter.toPublisher(attribute));
        }
        return Mono.justOrEmpty(attribute);
    }

    @Nullable
    private Object findAndRemoveReactiveAttribute(Model model, String attributeName) {
        return model.asMap().entrySet().stream().filter(entry -> {
            if (!((String)entry.getKey()).startsWith(attributeName)) {
                return false;
            }
            ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(null, entry.getValue());
            if (adapter == null) {
                return false;
            }
            String name = attributeName + ClassUtils.getShortName(adapter.getReactiveType());
            return ((String)entry.getKey()).equals(name);
        }).findFirst().map(entry -> {
            model.asMap().remove(entry.getKey());
            return entry.getValue();
        }).orElse(null);
    }

    private Mono<?> createAttribute(String attributeName, Class<?> clazz, BindingContext context, ServerWebExchange exchange2) {
        Constructor<?> ctor = BeanUtils.getResolvableConstructor(clazz);
        return this.constructAttribute(ctor, attributeName, context, exchange2);
    }

    private Mono<?> constructAttribute(Constructor<?> ctor, String attributeName, BindingContext context, ServerWebExchange exchange2) {
        if (ctor.getParameterCount() == 0) {
            return Mono.just(BeanUtils.instantiateClass(ctor, new Object[0]));
        }
        WebExchangeDataBinder binder = context.createDataBinder(exchange2, null, attributeName);
        return this.getValuesToBind(binder, exchange2).map(bindValues -> {
            String[] paramNames = BeanUtils.getParameterNames(ctor);
            Class<?>[] paramTypes = ctor.getParameterTypes();
            Object[] args = new Object[paramTypes.length];
            String fieldDefaultPrefix = binder.getFieldDefaultPrefix();
            String fieldMarkerPrefix = binder.getFieldMarkerPrefix();
            for (int i2 = 0; i2 < paramNames.length; ++i2) {
                String paramName = paramNames[i2];
                Class<?> paramType = paramTypes[i2];
                Object value = bindValues.get(paramName);
                if (value == null) {
                    if (fieldDefaultPrefix != null) {
                        value = bindValues.get(fieldDefaultPrefix + paramName);
                    }
                    if (value == null && fieldMarkerPrefix != null && bindValues.get(fieldMarkerPrefix + paramName) != null) {
                        value = binder.getEmptyValue(paramType);
                    }
                }
                value = value instanceof List ? ((List)value).toArray() : value;
                MethodParameter methodParam = new MethodParameter(ctor, i2);
                args[i2] = value == null && methodParam.isOptional() ? (methodParam.getParameterType() == Optional.class ? Optional.empty() : null) : binder.convertIfNecessary(value, paramTypes[i2], methodParam);
            }
            return BeanUtils.instantiateClass(ctor, args);
        });
    }

    public Mono<Map<String, Object>> getValuesToBind(WebExchangeDataBinder binder, ServerWebExchange exchange2) {
        return binder.getValuesToBind(exchange2);
    }

    private boolean hasErrorsArgument(MethodParameter parameter) {
        int i2 = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getExecutable().getParameterTypes();
        return paramTypes.length > i2 + 1 && Errors.class.isAssignableFrom(paramTypes[i2 + 1]);
    }

    private void validateIfApplicable(WebExchangeDataBinder binder, MethodParameter parameter) {
        for (Annotation ann : parameter.getParameterAnnotations()) {
            Object hints;
            Validated validatedAnn = AnnotationUtils.getAnnotation(ann, Validated.class);
            if (validatedAnn == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnn != null ? validatedAnn.value() : AnnotationUtils.getValue(ann);
            if (hints != null) {
                Object[] objectArray;
                if (hints instanceof Object[]) {
                    objectArray = hints;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = hints;
                }
                Object[] validationHints = objectArray;
                binder.validate(validationHints);
                continue;
            }
            binder.validate();
        }
    }
}

