/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.util.Objects;
import org.eclipse.jetty.reactive.client.internal.AbstractSinglePublisher;
import org.eclipse.jetty.util.MathUtils;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class AbstractSingleProcessor<I, O>
extends AbstractSinglePublisher<O>
implements Processor<I, O> {
    private Subscription upStream;
    private long demand;

    protected Subscriber<? super O> downStream() {
        return this.subscriber();
    }

    @Override
    protected void onFailure(Subscriber<? super O> subscriber, Throwable failure) {
        this.upStreamCancel();
        super.onFailure(subscriber, failure);
    }

    @Override
    public void cancel() {
        this.upStreamCancel();
        super.cancel();
    }

    private void upStreamCancel() {
        this.upStreamCancel(this.upStream());
    }

    private void upStreamCancel(Subscription upStream) {
        if (upStream != null) {
            upStream.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRequest(Subscriber<? super O> subscriber, long n) {
        Subscription upStream;
        long demand;
        AbstractSingleProcessor abstractSingleProcessor = this;
        synchronized (abstractSingleProcessor) {
            demand = MathUtils.cappedAdd(this.demand, n);
            upStream = this.upStream();
            this.demand = upStream == null ? demand : 0L;
        }
        this.upStreamRequest(upStream, demand);
    }

    protected void upStreamRequest(long n) {
        this.upStreamRequest(this.upStream(), n);
    }

    private void upStreamRequest(Subscription upStream, long demand) {
        if (upStream != null) {
            upStream.request(demand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription, "invalid 'null' subscription");
        long demand = 0L;
        boolean cancel = false;
        AbstractSingleProcessor abstractSingleProcessor = this;
        synchronized (abstractSingleProcessor) {
            if (this.upStream != null) {
                cancel = true;
            } else if (this.isCancelled()) {
                cancel = true;
            } else {
                this.upStream = subscription;
                demand = this.demand;
                this.demand = 0L;
            }
        }
        if (cancel) {
            subscription.cancel();
        } else if (demand > 0L) {
            subscription.request(demand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subscription upStream() {
        AbstractSingleProcessor abstractSingleProcessor = this;
        synchronized (abstractSingleProcessor) {
            return this.upStream;
        }
    }

    protected void downStreamOnNext(O item) {
        Subscriber<O> downStream = this.downStream();
        if (downStream != null) {
            downStream.onNext(item);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        Subscriber<O> downStream = this.downStream();
        if (downStream != null) {
            downStream.onError(throwable);
        }
    }

    @Override
    public void onComplete() {
        Subscriber<O> downStream = this.downStream();
        if (downStream != null) {
            downStream.onComplete();
        }
    }

    @Override
    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

