/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.jetty;

import com.fasterxml.jackson.core.async_.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveOptions;
import reactivefeign.jetty.JettyHttpClientFactory;
import reactivefeign.jetty.JettyReactiveOptions;
import reactivefeign.jetty.client.JettyReactiveHttpClient;

public final class JettyReactiveFeign {
    private JettyReactiveFeign() {
    }

    public static <T> Builder<T> builder() {
        return JettyReactiveFeign.builder((boolean useHttp2) -> {
            try {
                if (useHttp2) {
                    HTTP2Client h2Client = new HTTP2Client();
                    h2Client.setSelectors(1);
                    HttpClientTransportOverHTTP2 transport = new HttpClientTransportOverHTTP2(h2Client);
                    HttpClient httpClient = new HttpClient(transport, null);
                    httpClient.start();
                    return httpClient;
                }
                HttpClient httpClient = new HttpClient();
                httpClient.start();
                return httpClient;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static <T> Builder<T> builder(HttpClient httpClient) {
        return JettyReactiveFeign.builder((boolean useHttp2) -> httpClient);
    }

    public static <T> Builder<T> builder(JettyHttpClientFactory httpClientFactory) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        return new Builder(httpClientFactory, new JsonFactory(), objectMapper);
    }

    public static <T> Builder<T> builder(JettyHttpClientFactory httpClientFactory, JsonFactory jsonFactory, ObjectMapper objectMapper) {
        return new Builder(httpClientFactory, jsonFactory, objectMapper);
    }

    public static class Builder<T>
    extends ReactiveFeign.Builder<T> {
        protected JettyHttpClientFactory httpClientFactory;
        protected JsonFactory jsonFactory;
        private ObjectMapper objectMapper;
        protected JettyReactiveOptions options;

        protected Builder(JettyHttpClientFactory httpClientFactory, JsonFactory jsonFactory, ObjectMapper objectMapper) {
            this.jsonFactory = jsonFactory;
            this.objectMapper = objectMapper;
            this.setHttpClient(httpClientFactory);
        }

        @Override
        public Builder<T> options(ReactiveOptions options) {
            this.options = (JettyReactiveOptions)options;
            this.setHttpClient(this.httpClientFactory);
            return this;
        }

        protected void setHttpClient(JettyHttpClientFactory httpClientFactory) {
            this.httpClientFactory = httpClientFactory;
            boolean useHttp2 = ReactiveOptions.useHttp2(this.options);
            HttpClient httpClient = httpClientFactory.build(useHttp2);
            if (useHttp2 && !(httpClient.getTransport() instanceof HttpClientTransportOverHTTP2)) {
                throw new IllegalArgumentException("HttpClient should use HttpClientTransportOverHTTP2");
            }
            if (this.options != null && this.options.getConnectTimeoutMillis() != null) {
                httpClient.setConnectTimeout(this.options.getConnectTimeoutMillis());
            }
            if (this.options != null && this.options.isFollowRedirects() != null) {
                httpClient.setFollowRedirects(this.options.isFollowRedirects());
            }
            if (this.options != null && this.options.getProxySettings() != null) {
                ReactiveOptions.ProxySettings proxySettings = this.options.getProxySettings();
                httpClient.getProxyConfiguration().getProxies().add(new HttpProxy(proxySettings.getHost(), proxySettings.getPort()));
            }
            this.clientFactory(methodMetadata -> {
                JettyReactiveHttpClient jettyClient = JettyReactiveHttpClient.jettyClient(methodMetadata, httpClient, this.jsonFactory, this.objectMapper);
                if (this.options != null && this.options.getRequestTimeoutMillis() != null) {
                    jettyClient = jettyClient.setRequestTimeout(this.options.getRequestTimeoutMillis());
                }
                if (this.options != null && this.options.isTryUseCompression() != null) {
                    jettyClient = jettyClient.setTryUseCompression(this.options.isTryUseCompression());
                }
                return jettyClient;
            });
        }
    }
}

