/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.servlet.AsyncContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.JettyHeadersAdapter;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import org.springframework.http.server.reactive.ServletServerHttpRequest;
import org.springframework.http.server.reactive.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;

public class JettyHttpHandlerAdapter
extends ServletHttpHandlerAdapter {
    private static final boolean jetty10Present = ClassUtils.isPresent("org.eclipse.jetty.http.CookieCutter", JettyHttpHandlerAdapter.class.getClassLoader());

    public JettyHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    @Override
    protected ServletServerHttpRequest createRequest(HttpServletRequest request, AsyncContext context) throws IOException, URISyntaxException {
        if (jetty10Present) {
            return super.createRequest(request, context);
        }
        Assert.notNull((Object)this.getServletPath(), "Servlet path is not initialized");
        return new JettyServerHttpRequest(request, context, this.getServletPath(), this.getDataBufferFactory(), this.getBufferSize());
    }

    @Override
    protected ServletServerHttpResponse createResponse(HttpServletResponse response, AsyncContext context, ServletServerHttpRequest request) throws IOException {
        if (jetty10Present) {
            return new BaseJettyServerHttpResponse(response, context, this.getDataBufferFactory(), this.getBufferSize(), request);
        }
        return new JettyServerHttpResponse(response, context, this.getDataBufferFactory(), this.getBufferSize(), request);
    }

    private static final class JettyServerHttpResponse
    extends BaseJettyServerHttpResponse {
        JettyServerHttpResponse(HttpServletResponse response, AsyncContext asyncContext, DataBufferFactory bufferFactory, int bufferSize, ServletServerHttpRequest request) throws IOException {
            super(JettyServerHttpResponse.createHeaders(response), response, asyncContext, bufferFactory, bufferSize, request);
        }

        private static HttpHeaders createHeaders(HttpServletResponse response) {
            HttpFields fields = ((Response)response).getHttpFields();
            return new HttpHeaders(new JettyHeadersAdapter(fields));
        }

        @Override
        protected void applyHeaders() {
            long contentLength;
            Charset charset;
            HttpServletResponse response = (HttpServletResponse)this.getNativeResponse();
            MediaType contentType2 = null;
            try {
                contentType2 = this.getHeaders().getContentType();
            }
            catch (Exception ex) {
                String rawContentType = this.getHeaders().getFirst("Content-Type");
                response.setContentType(rawContentType);
            }
            if (response.getContentType() == null && contentType2 != null) {
                response.setContentType(contentType2.toString());
            }
            Charset charset2 = charset = contentType2 != null ? contentType2.getCharset() : null;
            if (response.getCharacterEncoding() == null && charset != null) {
                response.setCharacterEncoding(charset.name());
            }
            if ((contentLength = this.getHeaders().getContentLength()) != -1L) {
                response.setContentLengthLong(contentLength);
            }
        }
    }

    private static class BaseJettyServerHttpResponse
    extends ServletServerHttpResponse {
        BaseJettyServerHttpResponse(HttpServletResponse response, AsyncContext asyncContext, DataBufferFactory bufferFactory, int bufferSize, ServletServerHttpRequest request) throws IOException {
            super(response, asyncContext, bufferFactory, bufferSize, request);
        }

        BaseJettyServerHttpResponse(HttpHeaders headers2, HttpServletResponse response, AsyncContext asyncContext, DataBufferFactory bufferFactory, int bufferSize, ServletServerHttpRequest request) throws IOException {
            super(headers2, response, asyncContext, bufferFactory, bufferSize, request);
        }

        @Override
        protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
            ByteBuffer input = dataBuffer.asByteBuffer();
            int len = input.remaining();
            ServletResponse response = (ServletResponse)this.getNativeResponse();
            ((HttpOutput)response.getOutputStream()).write(input);
            return len;
        }
    }

    private static final class JettyServerHttpRequest
    extends ServletServerHttpRequest {
        JettyServerHttpRequest(HttpServletRequest request, AsyncContext asyncContext, String servletPath, DataBufferFactory bufferFactory, int bufferSize) throws IOException, URISyntaxException {
            super(JettyServerHttpRequest.createHeaders(request), request, asyncContext, servletPath, bufferFactory, bufferSize);
        }

        private static MultiValueMap<String, String> createHeaders(HttpServletRequest request) {
            HttpFields fields = ((Request)request).getMetaData().getFields();
            return new JettyHeadersAdapter(fields);
        }
    }
}

