/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.Validate;

public class MethodHelper
implements Helper<Object> {
    private static final Object[] NO_ARGS = new Object[0];
    private Object source;
    private Method method;

    public MethodHelper(Method method2, Object source) {
        this.method = Validate.notNull(method2, "A helper method is required.", new Object[0]);
        this.source = source;
    }

    @Override
    public Object apply(Object context, Options options) throws IOException {
        try {
            Class<?>[] paramTypes = this.method.getParameterTypes();
            Object[] args = NO_ARGS;
            if (paramTypes.length > 0) {
                args = new Object[paramTypes.length];
                args[0] = paramTypes[0] == Options.class ? options : context;
                for (int i2 = 1; i2 < args.length; ++i2) {
                    args[i2] = paramTypes[i2] == Options.class ? options : options.param(i2 - 1);
                }
            }
            return this.method.invoke(this.source, args);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("could not execute helper: " + this.toString(this.method) + ", with the given arguments: " + this.toString(options.params), ex);
        }
        catch (InvocationTargetException ex) {
            throw this.launderThrowable(ex.getCause());
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("could not execute helper: " + this.toString(this.method), ex);
        }
    }

    private String toString(Object[] params) {
        StringBuilder buff = new StringBuilder();
        buff.append("[");
        for (Object param : params) {
            buff.append(param == null ? "null" : param.getClass().getSimpleName()).append(", ");
        }
        if (buff.length() > 1) {
            buff.setLength(buff.length() - 2);
        }
        return buff.append("]").toString();
    }

    private String toString(Method method2) {
        return method2.getName() + "(" + this.toString(method2.getParameterTypes()) + ")";
    }

    private String toString(Class<?>[] types) {
        StringBuilder buff = new StringBuilder();
        for (Class<?> type : types) {
            buff.append(type.getSimpleName()).append(", ");
        }
        if (buff.length() > 0) {
            buff.setLength(buff.length() - 2);
        }
        return buff.toString();
    }

    private RuntimeException launderThrowable(Throwable cause) throws IOException {
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        return new IllegalStateException("could not execute helper: " + this.method.getName(), cause);
    }
}

