/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.reactivestreams.Publisher;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Hints;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.HandlerResultHandlerSupport;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageWriterResultHandler
extends HandlerResultHandlerSupport {
    private static final String COROUTINES_FLOW_CLASS_NAME = "kotlinx.coroutines.flow.Flow";
    private final List<HttpMessageWriter<?>> messageWriters;

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver) {
        this(messageWriters, contentTypeResolver, ReactiveAdapterRegistry.getSharedInstance());
    }

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        super(contentTypeResolver, adapterRegistry);
        Assert.notEmpty(messageWriters, "At least one message writer is required");
        this.messageWriters = messageWriters;
    }

    public List<HttpMessageWriter<?>> getMessageWriters() {
        return this.messageWriters;
    }

    protected Mono<Void> writeBody(@Nullable Object body2, MethodParameter bodyParameter, ServerWebExchange exchange2) {
        return this.writeBody(body2, bodyParameter, null, exchange2);
    }

    protected Mono<Void> writeBody(@Nullable Object body2, MethodParameter bodyParameter, @Nullable MethodParameter actualParam, ServerWebExchange exchange2) {
        MediaType contentType2;
        ResolvableType actualElementType;
        ResolvableType elementType;
        Publisher<Object> publisher;
        ResolvableType bodyType = ResolvableType.forMethodParameter(bodyParameter);
        ResolvableType actualType = actualParam != null ? ResolvableType.forMethodParameter(actualParam) : bodyType;
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(bodyType.resolve(), body2);
        if (adapter != null) {
            publisher = adapter.toPublisher(body2);
            boolean isUnwrapped = KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(bodyParameter.getContainingClass()) && KotlinDelegate.isSuspend(bodyParameter.getMethod()) && !COROUTINES_FLOW_CLASS_NAME.equals(bodyType.toClass().getName());
            ResolvableType genericType = isUnwrapped ? bodyType : bodyType.getGeneric(new int[0]);
            actualElementType = elementType = this.getElementType(adapter, genericType);
        } else {
            publisher = Mono.justOrEmpty(body2);
            actualElementType = body2 != null ? ResolvableType.forInstance(body2) : bodyType;
            ResolvableType resolvableType = elementType = bodyType.toClass() == Object.class && body2 != null ? actualElementType : bodyType;
        }
        if (elementType.resolve() == Void.TYPE || elementType.resolve() == Void.class) {
            return Mono.from(publisher);
        }
        MediaType bestMediaType = this.selectMediaType(exchange2, () -> this.getMediaTypesFor(elementType));
        if (bestMediaType != null) {
            String logPrefix = exchange2.getLogPrefix();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(logPrefix + (publisher instanceof Mono ? "0..1" : "0..N") + " [" + elementType + "]");
            }
            for (HttpMessageWriter<?> writer : this.getMessageWriters()) {
                if (!writer.canWrite(actualElementType, bestMediaType)) continue;
                return writer.write(publisher, actualType, elementType, bestMediaType, exchange2.getRequest(), exchange2.getResponse(), Hints.from(Hints.LOG_PREFIX_HINT, logPrefix));
            }
        }
        boolean isPresentMediaType = (contentType2 = exchange2.getResponse().getHeaders().getContentType()) != null && contentType2.equals(bestMediaType);
        Set producibleTypes = (Set)exchange2.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        if (isPresentMediaType || !CollectionUtils.isEmpty(producibleTypes)) {
            return Mono.error(new HttpMessageNotWritableException("No Encoder for [" + elementType + "] with preset Content-Type '" + contentType2 + "'"));
        }
        List<MediaType> mediaTypes = this.getMediaTypesFor(elementType);
        if (bestMediaType == null && mediaTypes.isEmpty()) {
            return Mono.error(new IllegalStateException("No HttpMessageWriter for " + elementType));
        }
        return Mono.error(new NotAcceptableStatusException(mediaTypes));
    }

    private ResolvableType getElementType(ReactiveAdapter adapter, ResolvableType genericType) {
        if (adapter.isNoValue()) {
            return ResolvableType.forClass(Void.class);
        }
        if (genericType != ResolvableType.NONE) {
            return genericType;
        }
        return ResolvableType.forClass(Object.class);
    }

    private List<MediaType> getMediaTypesFor(ResolvableType elementType) {
        ArrayList<MediaType> writableMediaTypes = new ArrayList<MediaType>();
        for (HttpMessageWriter<?> converter : this.getMessageWriters()) {
            if (!converter.canWrite(elementType, null)) continue;
            writableMediaTypes.addAll(converter.getWritableMediaTypes());
        }
        return writableMediaTypes;
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        private static boolean isSuspend(Method method2) {
            KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method2);
            return function != null && function.isSuspend();
        }
    }
}

