/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.XmlException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathFactory;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Xml {
    private Xml() {
    }

    public static void optimizeFactoriesLoading() {
        String transformerFactoryImpl = TransformerFactory.newInstance().getClass().getName();
        String xPathFactoryImpl = XPathFactory.newInstance().getClass().getName();
        Xml.setProperty(TransformerFactory.class.getName(), transformerFactoryImpl);
        Xml.setProperty("javax.xml.xpath.XPathFactory:http://java.sun.com/jaxp/xpath/dom", xPathFactoryImpl);
        XMLUnit.setTransformerFactory(transformerFactoryImpl);
        XMLUnit.setXPathFactory(xPathFactoryImpl);
    }

    private static String setProperty(final String name, final String value) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty(name, value);
            }
        });
    }

    public static String prettyPrint(String xml) {
        try {
            return Xml.prettyPrint(Xml.read(xml));
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    public static String prettyPrint(Document doc) {
        try {
            TransformerFactory transformerFactory = Xml.createTransformerFactory();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    private static TransformerFactory createTransformerFactory() {
        try {
            TransformerFactory transformerFactory = (TransformerFactory)Class.forName("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl").newInstance();
            transformerFactory.setAttribute("indent-number", 2);
            return transformerFactory;
        }
        catch (Exception e) {
            return TransformerFactory.newInstance();
        }
    }

    public static Document read(String xml) {
        try {
            DocumentBuilderFactory dbf = Xml.newDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            return db.parse(is);
        }
        catch (SAXException e) {
            throw XmlException.fromSaxException(e);
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, Document.class);
        }
    }

    public static String toStringValue(Node node) {
        switch (node.getNodeType()) {
            case 2: 
            case 3: {
                return node.getTextContent();
            }
            case 1: {
                return Xml.render(node);
            }
        }
        return node.toString();
    }

    public static String render(Node node) {
        try {
            StringWriter sw = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        return new SkipResolvingEntitiesDocumentBuilderFactory();
    }

    private static class SkipResolvingEntitiesDocumentBuilderFactory
    extends DocumentBuilderFactory {
        private static final ThreadLocal<DocumentBuilderFactory> DBF_CACHE = new ThreadLocal<DocumentBuilderFactory>(){

            @Override
            protected DocumentBuilderFactory initialValue() {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setFeature("http://xml.org/sax/features/validation", false);
                    dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                    dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    return dbf;
                }
                catch (ParserConfigurationException e) {
                    return Exceptions.throwUnchecked(e, DocumentBuilderFactory.class);
                }
            }
        };
        private static final ThreadLocal<DocumentBuilder> DB_CACHE = new ThreadLocal<DocumentBuilder>(){

            @Override
            protected DocumentBuilder initialValue() {
                try {
                    return ((DocumentBuilderFactory)DBF_CACHE.get()).newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    return Exceptions.throwUnchecked(e, DocumentBuilder.class);
                }
            }

            @Override
            public DocumentBuilder get() {
                DocumentBuilder documentBuilder = (DocumentBuilder)super.get();
                documentBuilder.setEntityResolver(new ResolveToEmptyString());
                documentBuilder.setErrorHandler(null);
                return documentBuilder;
            }
        };

        private SkipResolvingEntitiesDocumentBuilderFactory() {
        }

        @Override
        public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
            return DB_CACHE.get();
        }

        @Override
        public void setAttribute(String name, Object value) {
            DBF_CACHE.get().setAttribute(name, value);
        }

        @Override
        public Object getAttribute(String name) {
            return DBF_CACHE.get().getAttribute(name);
        }

        @Override
        public void setFeature(String name, boolean value) throws ParserConfigurationException {
            DBF_CACHE.get().setFeature(name, value);
        }

        @Override
        public boolean getFeature(String name) throws ParserConfigurationException {
            return DBF_CACHE.get().getFeature(name);
        }

        private static class ResolveToEmptyString
        implements EntityResolver {
            private ResolveToEmptyString() {
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        }
    }
}

