/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import java.util.Objects;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpClient;
import reactor.netty.tcp.TcpClientOperator;

final class TcpClientRunOn
extends TcpClientOperator {
    final LoopResources loopResources;
    final boolean preferNative;

    TcpClientRunOn(TcpClient client, LoopResources loopResources, boolean preferNative) {
        super(client);
        this.loopResources = Objects.requireNonNull(loopResources, "loopResources");
        this.preferNative = preferNative;
    }

    @Override
    public Bootstrap configure() {
        Bootstrap b = this.source.configure();
        TcpClientRunOn.configure(b, this.preferNative, this.loopResources);
        return b;
    }

    static void configure(Bootstrap b, boolean preferNative, LoopResources resources2) {
        EventLoopGroup elg = resources2.onClient(preferNative);
        ((Bootstrap)b.group(elg)).channel(resources2.onChannel(elg));
    }
}

