/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.core;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.GroupThreads;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.FieldInfo;
import org.openjdk.jmh.generators.core.GenerationException;
import org.openjdk.jmh.generators.core.GeneratorSource;
import org.openjdk.jmh.generators.core.MethodGroup;
import org.openjdk.jmh.generators.core.MethodInfo;
import org.openjdk.jmh.generators.core.ParameterInfo;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.Multimap;

class BenchmarkGeneratorUtils {
    private static final Collection<Class<? extends Annotation>> JMH_ANNOTATIONS = Arrays.asList(AuxCounters.class, BenchmarkMode.class, CompilerControl.class, Fork.class, Benchmark.class, Group.class, GroupThreads.class, Measurement.class, OperationsPerInvocation.class, OutputTimeUnit.class, Param.class, Setup.class, State.class, TearDown.class, Threads.class, Warmup.class);
    private static final Multimap<Class<? extends Annotation>, ElementType> JMH_ANNOTATION_TARGETS = new HashMultimap<Class<? extends Annotation>, ElementType>();

    BenchmarkGeneratorUtils() {
    }

    public static boolean checkJavaIdentifier(String id) {
        for (int i2 = 0; i2 < id.length(); ++i2) {
            char c = id.charAt(i2);
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Annotation> Collection<MethodInfo> getMethodsAnnotatedWith(GeneratorSource source, Class<T> annClass) {
        ArrayList<MethodInfo> mis = new ArrayList<MethodInfo>();
        for (ClassInfo ci : source.getClasses()) {
            for (MethodInfo mi : ci.getMethods()) {
                if (mi.getAnnotation(annClass) == null) continue;
                mis.add(mi);
            }
        }
        return mis;
    }

    public static <T extends Annotation> Collection<ClassInfo> getClassesAnnotatedWith(GeneratorSource source, Class<T> annClass) {
        ArrayList<ClassInfo> cis = new ArrayList<ClassInfo>();
        for (ClassInfo ci : source.getClasses()) {
            if (ci.getAnnotation(annClass) == null) continue;
            cis.add(ci);
        }
        return cis;
    }

    public static <T extends Annotation> Collection<FieldInfo> getFieldsAnnotatedWith(GeneratorSource source, Class<T> annClass) {
        ArrayList<FieldInfo> mis = new ArrayList<FieldInfo>();
        for (ClassInfo ci : source.getClasses()) {
            for (FieldInfo mi : ci.getFields()) {
                if (mi.getAnnotation(annClass) == null) continue;
                mis.add(mi);
            }
        }
        return mis;
    }

    public static Collection<FieldInfo> getAllFields(ClassInfo ci) {
        ArrayList<FieldInfo> ls = new ArrayList<FieldInfo>();
        do {
            ls.addAll(ci.getFields());
        } while ((ci = ci.getSuperClass()) != null);
        return ls;
    }

    public static Collection<MethodInfo> getAllMethods(ClassInfo ci) {
        ArrayList<MethodInfo> ls = new ArrayList<MethodInfo>();
        do {
            ls.addAll(ci.getMethods());
        } while ((ci = ci.getSuperClass()) != null);
        return ls;
    }

    public static Collection<MethodInfo> getMethods(ClassInfo ci) {
        ArrayList<MethodInfo> ls = new ArrayList<MethodInfo>();
        do {
            ls.addAll(ci.getMethods());
        } while ((ci = ci.getSuperClass()) != null);
        return ls;
    }

    public static <T extends Annotation> T getAnnSuper(ClassInfo ci, Class<T> annClass) {
        T ann = ci.getAnnotation(annClass);
        if (ann != null) {
            return ann;
        }
        ClassInfo eci = ci.getSuperClass();
        if (eci != null) {
            return BenchmarkGeneratorUtils.getAnnSuper(eci, annClass);
        }
        return null;
    }

    public static <T extends Annotation> T getAnnSyntax(ClassInfo ci, Class<T> annClass) {
        T ann = ci.getAnnotation(annClass);
        if (ann != null) {
            return ann;
        }
        ClassInfo eci = ci.getDeclaringClass();
        if (eci != null) {
            return BenchmarkGeneratorUtils.getAnnSyntax(eci, annClass);
        }
        return null;
    }

    public static <T extends Annotation> T getAnnSyntax(MethodInfo mi, Class<T> annClass) {
        T ann = mi.getAnnotation(annClass);
        if (ann != null) {
            return ann;
        }
        return BenchmarkGeneratorUtils.getAnnSyntax(mi.getDeclaringClass(), annClass);
    }

    public static <T extends Annotation> T getAnnSuper(MethodInfo mi, Class<T> annClass) {
        T ann = mi.getAnnotation(annClass);
        if (ann != null) {
            return ann;
        }
        return BenchmarkGeneratorUtils.getAnnSuper(mi.getDeclaringClass(), annClass);
    }

    public static <T extends Annotation> T getAnnSuper(MethodInfo mi, ClassInfo startCi, Class<T> annClass) {
        T ann = mi.getAnnotation(annClass);
        if (ann != null) {
            return ann;
        }
        return BenchmarkGeneratorUtils.getAnnSuper(startCi, annClass);
    }

    public static <T extends Annotation> Collection<T> getAnnSuperAll(MethodInfo mi, ClassInfo startCi, Class<T> annClass) {
        ArrayList<T> results = new ArrayList<T>();
        T ann = mi.getAnnotation(annClass);
        if (ann != null) {
            results.add(ann);
        }
        ClassInfo ci = startCi;
        do {
            T ann2;
            if ((ann2 = ci.getAnnotation(annClass)) == null) continue;
            results.add(ann2);
        } while ((ci = ci.getSuperClass()) != null);
        return results;
    }

    public static String getGeneratedName(ClassInfo ci) {
        String name = "";
        do {
            name = ci.getName() + (name.isEmpty() ? "" : "_" + name);
        } while ((ci = ci.getDeclaringClass()) != null);
        return name;
    }

    public static String getNestedNames(ClassInfo ci) {
        String name = "";
        do {
            name = ci.getName() + (name.isEmpty() ? "" : "$" + name);
        } while ((ci = ci.getDeclaringClass()) != null);
        return name;
    }

    public static void checkAnnotations(FieldInfo fi) {
        for (Class<? extends Annotation> ann : JMH_ANNOTATIONS) {
            if (fi.getAnnotation(ann) == null || JMH_ANNOTATION_TARGETS.get(ann).contains((Object)ElementType.FIELD)) continue;
            throw new GenerationException("Annotation @" + ann.getSimpleName() + " is not applicable to fields.", fi);
        }
    }

    public static void checkAnnotations(ClassInfo ci) {
        for (Class<? extends Annotation> ann : JMH_ANNOTATIONS) {
            if (ci.getAnnotation(ann) == null || JMH_ANNOTATION_TARGETS.get(ann).contains((Object)ElementType.TYPE)) continue;
            throw new GenerationException("Annotation @" + ann.getSimpleName() + " is not applicable to types.", ci);
        }
    }

    public static void checkAnnotations(MethodInfo mi) {
        for (Class<? extends Annotation> ann : JMH_ANNOTATIONS) {
            if (mi.getAnnotation(ann) == null || JMH_ANNOTATION_TARGETS.get(ann).contains((Object)ElementType.METHOD)) continue;
            throw new GenerationException("Annotation @" + ann.getSimpleName() + " is not applicable to methods.", mi);
        }
    }

    private static String[] toParameterValues(FieldInfo fi) {
        boolean isBlankEnum;
        String[] annotatedValues = fi.getAnnotation(Param.class).value();
        boolean bl = isBlankEnum = annotatedValues.length == 1 && "blank_blank_blank_2014".equals(annotatedValues[0]) && fi.getType().isEnum();
        if (isBlankEnum) {
            Collection<String> enumConstants = fi.getType().getEnumConstants();
            if (enumConstants.isEmpty()) {
                throw new GenerationException("Enum type of field had no constants. Declare some constants or remove the @" + Param.class.getSimpleName() + ".", fi);
            }
            return enumConstants.toArray(new String[0]);
        }
        return annotatedValues;
    }

    static void addParameterValuesToGroup(ClassInfo host, MethodGroup group) {
        for (FieldInfo fi : BenchmarkGeneratorUtils.getAllFields(host)) {
            if (fi.getAnnotation(Param.class) == null) continue;
            String[] values = BenchmarkGeneratorUtils.toParameterValues(fi);
            group.addParamValues(fi.getName(), values);
        }
        for (MethodInfo mi : BenchmarkGeneratorUtils.getAllMethods(host)) {
            if (mi.getAnnotation(Setup.class) == null && mi.getAnnotation(TearDown.class) == null) continue;
            for (ParameterInfo pi : mi.getParameters()) {
                BenchmarkGeneratorUtils.addParameterValuesToGroup(pi.getType(), group);
            }
        }
    }

    static {
        for (Class<? extends Annotation> ann : JMH_ANNOTATIONS) {
            ElementType[] types;
            Target target = ann.getAnnotation(Target.class);
            if (target == null) continue;
            for (ElementType type : types = target.value()) {
                JMH_ANNOTATION_TARGETS.put(ann, type);
            }
        }
    }
}

