/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web;

import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import javax.servlet.ServletException;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class HttpRequestMethodNotSupportedException
extends ServletException {
    private final String method;
    @Nullable
    private final String[] supportedMethods;

    public HttpRequestMethodNotSupportedException(String method2) {
        this(method2, (String[])null);
    }

    public HttpRequestMethodNotSupportedException(String method2, String msg) {
        this(method2, null, msg);
    }

    public HttpRequestMethodNotSupportedException(String method2, @Nullable Collection<String> supportedMethods) {
        this(method2, supportedMethods != null ? StringUtils.toStringArray(supportedMethods) : null);
    }

    public HttpRequestMethodNotSupportedException(String method2, @Nullable String[] supportedMethods) {
        this(method2, supportedMethods, "Request method '" + method2 + "' not supported");
    }

    public HttpRequestMethodNotSupportedException(String method2, @Nullable String[] supportedMethods, String msg) {
        super(msg);
        this.method = method2;
        this.supportedMethods = supportedMethods;
    }

    public String getMethod() {
        return this.method;
    }

    @Nullable
    public String[] getSupportedMethods() {
        return this.supportedMethods;
    }

    @Nullable
    public Set<HttpMethod> getSupportedHttpMethods() {
        if (this.supportedMethods == null) {
            return null;
        }
        LinkedList<HttpMethod> supportedMethods = new LinkedList<HttpMethod>();
        for (String value : this.supportedMethods) {
            HttpMethod resolved = HttpMethod.resolve(value);
            if (resolved == null) continue;
            supportedMethods.add(resolved);
        }
        return EnumSet.copyOf(supportedMethods);
    }
}

