/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassUtils {
    private static final boolean USE_SEPARATE_CLASSLOADER = Boolean.getBoolean("jmh.separateClassLoader");

    private ClassUtils() {
    }

    public static List<Method> enumerateMethods(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            result.addAll(Arrays.asList(current.getDeclaredMethods()));
        }
        return result;
    }

    public static Class<?> loadClass(String className) {
        try {
            if (!USE_SEPARATE_CLASSLOADER) {
                return Class.forName(className);
            }
            String classPathValue = System.getProperty("java.class.path");
            String[] classPath = classPathValue.split(File.pathSeparator);
            URL[] classPathUrl = new URL[classPath.length];
            for (int i2 = 0; i2 < classPathUrl.length; ++i2) {
                try {
                    classPathUrl[i2] = new File(classPath[i2]).toURI().toURL();
                    continue;
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException("Error parsing the value of property java.class.path: " + classPathValue, ex);
                }
            }
            URLClassLoader loader = new URLClassLoader(classPathUrl);
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Benchmark does not match a class", ex);
        }
    }

    public static Map<String, String> denseClassNames(Collection<String> src) {
        if (src.isEmpty()) {
            return Collections.emptyMap();
        }
        int maxLen = Integer.MIN_VALUE;
        for (String s : src) {
            maxLen = Math.max(maxLen, s.length());
        }
        boolean first = true;
        boolean prefixCut = false;
        String[] prefix = new String[]{};
        for (String s : src) {
            String p;
            String n;
            int c;
            String[] names = s.split("\\.");
            if (first) {
                prefix = new String[names.length];
                for (c = 0; c < names.length && names[c].toLowerCase().equals(names[c]); ++c) {
                    prefix[c] = names[c];
                }
                prefix = Arrays.copyOf(prefix, c);
                first = false;
                continue;
            }
            for (c = 0; c < Math.min(prefix.length, names.length) && (n = names[c]).equals(p = prefix[c]) && n.toLowerCase().equals(n); ++c) {
            }
            if (prefix.length != c) {
                prefixCut = true;
            }
            prefix = Arrays.copyOf(prefix, c);
        }
        for (int c = 0; c < prefix.length; ++c) {
            prefix[c] = prefixCut ? String.valueOf(prefix[c].charAt(0)) : "";
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : src) {
            int prefixLen = prefix.length;
            String[] names = s.split("\\.");
            System.arraycopy(prefix, 0, names, 0, prefixLen);
            String dense = "";
            for (String n : names) {
                if (n.isEmpty()) continue;
                dense = dense + n + ".";
            }
            if (dense.endsWith(".")) {
                dense = dense.substring(0, dense.length() - 1);
            }
            result.put(s, dense);
        }
        return result;
    }
}

