/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client.statushandler;

import java.util.Arrays;
import java.util.List;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactor.core.publisher.Mono;

public class CompositeStatusHandler
implements ReactiveStatusHandler {
    private final List<ReactiveStatusHandler> handlers;

    public static CompositeStatusHandler compose(ReactiveStatusHandler ... handlers) {
        return new CompositeStatusHandler(Arrays.asList(handlers));
    }

    private CompositeStatusHandler(List<ReactiveStatusHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public boolean shouldHandle(int status) {
        return this.handlers.stream().anyMatch(handler -> handler.shouldHandle(status));
    }

    public Mono<? extends Throwable> decode(String methodKey, ReactiveHttpResponse response) {
        return this.handlers.stream().filter(statusHandler -> statusHandler.shouldHandle(response.status())).findFirst().map(statusHandler -> statusHandler.decode(methodKey, response)).orElse(null);
    }
}

