/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util.lines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.Optional;
import org.openjdk.jmh.util.lines.Armor;

public class TestLineReader {
    private final String line;
    private final boolean correct;
    private int cursor;

    public TestLineReader(String line) {
        this.line = line;
        this.correct = line.length() > "JMH ".length() && line.startsWith("JMH ");
        this.cursor = "JMH ".length();
    }

    private int readLen() {
        StringBuilder sb = new StringBuilder();
        char c = this.line.charAt(this.cursor);
        while (Character.isDigit(c)) {
            sb.append(c);
            ++this.cursor;
            c = this.line.charAt(this.cursor);
        }
        ++this.cursor;
        return Integer.parseInt(sb.toString());
    }

    private String readString() {
        int len = this.readLen();
        String s2 = this.line.substring(this.cursor, this.cursor + len);
        this.cursor += len + 1;
        return s2;
    }

    private String readArmoredString() {
        return Armor.decode(this.readString());
    }

    private char readChar() {
        char c = this.line.charAt(this.cursor);
        this.cursor += 2;
        return c;
    }

    public String nextString() {
        char tag = this.readChar();
        if (tag == 'S') {
            return this.readString();
        }
        throw this.error("unexpected tag = " + tag);
    }

    private RuntimeException error(String msg) {
        return new IllegalStateException("Error: " + msg + "\n at \"" + this.line + "\", pos " + this.cursor);
    }

    public boolean isCorrect() {
        return this.correct;
    }

    public Optional<Integer> nextOptionalInt() {
        char tag = this.readChar();
        if (tag == 'E') {
            return Optional.none();
        }
        if (tag == 'I') {
            return Optional.of(Integer.valueOf(this.readString()));
        }
        throw this.error("unexpected tag = " + tag);
    }

    public Optional<String> nextOptionalString() {
        char tag = this.readChar();
        if (tag == 'E') {
            return Optional.none();
        }
        if (tag == 'S') {
            return Optional.of(this.readString());
        }
        throw this.error("unexpected tag = " + tag);
    }

    public Optional<TimeValue> nextOptionalTimeValue() {
        char tag = this.readChar();
        if (tag == 'E') {
            return Optional.none();
        }
        if (tag == 'T') {
            return Optional.of(TimeValue.fromString(this.readString()));
        }
        throw this.error("unexpected tag = " + tag);
    }

    public Optional<TimeUnit> nextOptionalTimeUnit() {
        char tag = this.readChar();
        if (tag == 'E') {
            return Optional.none();
        }
        if (tag == 'U') {
            return Optional.of(TimeUnit.valueOf(this.readString()));
        }
        throw this.error("unexpected tag = " + tag);
    }

    public Optional<Collection<String>> nextOptionalStringCollection() {
        char tag = this.readChar();
        if (tag == 'E') {
            return Optional.none();
        }
        if (tag == 'L') {
            int len = this.readLen();
            ArrayList<String> list = new ArrayList<String>();
            for (int c = 0; c < len; ++c) {
                list.add(this.readString());
            }
            return Optional.of(list);
        }
        throw this.error("unexpected tag = " + tag);
    }

    public int[] nextIntArray() {
        char tag = this.readChar();
        if (tag == 'A') {
            int len = this.readLen();
            int[] rs = new int[len];
            for (int c = 0; c < len; ++c) {
                rs[c] = Integer.parseInt(this.readString());
            }
            return rs;
        }
        throw this.error("unexpected tag = " + tag);
    }

    public Optional<Map<String, String[]>> nextOptionalParamCollection() {
        char tag = this.readChar();
        if (tag == 'E') {
            return Optional.none();
        }
        if (tag == 'M') {
            HashMap<String, String[]> result = new HashMap<String, String[]>();
            int kvs = this.readLen();
            for (int kv = 0; kv < kvs; ++kv) {
                String key = this.readString();
                int vlen = this.readLen();
                String[] values = new String[vlen];
                for (int v = 0; v < vlen; ++v) {
                    values[v] = this.readArmoredString();
                }
                result.put(key, values);
            }
            return Optional.of(result);
        }
        throw this.error("unexpected tag = " + tag);
    }
}

