/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.TextResult;
import org.openjdk.jmh.runner.IterationType;
import org.openjdk.jmh.util.FileUtils;

public final class AsyncProfiler
implements ExternalProfiler,
InternalProfiler {
    private static final String DEFAULT_EVENT = "cpu";
    private final JavaApi instance;
    private final boolean verbose;
    private final Direction direction;
    private final String profilerConfig;
    private final List<OutputType> output;
    private final String event;
    private final File outDir;
    private final int traces;
    private final int flat;
    private boolean warmupStarted = false;
    private boolean measurementStarted = false;
    private int measurementIterationCount;
    private final List<File> generated = new ArrayList<File>();

    public AsyncProfiler(String initLine) throws ProfilerException {
        OptionParser parser = new OptionParser();
        parser.formatHelpWith(new ProfilerOptionFormatter("async"));
        ArgumentAcceptingOptionSpec<OutputType> optOutput = parser.accepts("output", "Output format(s). Supported: " + EnumSet.allOf(OutputType.class).toString() + ".").withRequiredArg().ofType(OutputType.class).withValuesSeparatedBy(",").describedAs("format+").defaultsTo(OutputType.text, (OutputType[])new OutputType[0]);
        ArgumentAcceptingOptionSpec<Direction> optDirection = parser.accepts("direction", "Direction(s) of flame graph. Supported: " + EnumSet.allOf(Direction.class) + ".").withRequiredArg().ofType(Direction.class).describedAs("direction").defaultsTo(Direction.both, (Direction[])new Direction[0]);
        ArgumentAcceptingOptionSpec<String> optLibPath = parser.accepts("libPath", "Location of asyncProfiler library. If not specified, System.loadLibrary will be used and the library must be made available to the forked JVM in an entry of -Djava.library.path or LD_LIBRARY_PATH.").withRequiredArg().ofType(String.class).describedAs("path");
        ArgumentAcceptingOptionSpec<String> optEvent = parser.accepts("event", "Event to sample: cpu, alloc, wall, lock, cache-misses, etc.").withRequiredArg().ofType(String.class).describedAs("event").defaultsTo(DEFAULT_EVENT, (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> optDir = parser.accepts("dir", "Output directory.").withRequiredArg().ofType(String.class).describedAs("dir");
        ArgumentAcceptingOptionSpec<Long> optInterval = parser.accepts("interval", "Profiling interval.").withRequiredArg().ofType(Long.class).describedAs("ns");
        ArgumentAcceptingOptionSpec<Integer> optJstackDepth = parser.accepts("jstackdepth", "Maximum Java stack depth.").withRequiredArg().ofType(Integer.class).describedAs("frames");
        ArgumentAcceptingOptionSpec<Long> optFrameBuf = parser.accepts("framebuf", "Size of profiler framebuffer.").withRequiredArg().ofType(Long.class).describedAs("bytes");
        ArgumentAcceptingOptionSpec<Boolean> optFilter = parser.accepts("filter", "Enable thread filtering during collection. Useful for wall clock profiling, but only if the workload registers the relevant threads programatically via `AsyncProfiler.JavaApi.getInstance().filterThread(thread, enabled)`.").withRequiredArg().ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]).describedAs("boolean");
        ArgumentAcceptingOptionSpec<Boolean> optThreads = parser.accepts("threads", "Profile threads separately.").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<Boolean> optSimple = parser.accepts("simple", "Simple class names instead of FQN.").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<Boolean> optSig = parser.accepts("sig", "Print method signatures.").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<Boolean> optAnn = parser.accepts("ann", "Annotate Java method names.").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<String> optInclude = parser.accepts("include", "Output only stack traces containing the specified pattern.").withRequiredArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("regexp+");
        ArgumentAcceptingOptionSpec<String> optExclude = parser.accepts("exclude", "Exclude stack traces with the specified pattern.").withRequiredArg().withValuesSeparatedBy(",").ofType(String.class).describedAs("regexp+");
        ArgumentAcceptingOptionSpec<String> optRawCommand = parser.accepts("rawCommand", "Command to pass directly to async-profiler. Use to access new features of JMH profiler that are not yet supported in this option parser.").withRequiredArg().ofType(String.class).describedAs("command");
        ArgumentAcceptingOptionSpec<String> optTitle = parser.accepts("title", "SVG title.").withRequiredArg().ofType(String.class).describedAs("string");
        ArgumentAcceptingOptionSpec<Long> optWidth = parser.accepts("width", "SVG width.").withRequiredArg().ofType(Long.class).describedAs("pixels");
        ArgumentAcceptingOptionSpec<Long> optMinWidth = parser.accepts("minwidth", "Skip frames smaller than px").withRequiredArg().ofType(Long.class).describedAs("pixels");
        ArgumentAcceptingOptionSpec<Boolean> optAllKernel = parser.accepts("allkernel", "Only include kernel-mode events.").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<Boolean> optAllUser = parser.accepts("alluser", "Only include user-mode events.").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<CStackMode> optCStack = parser.accepts("cstack", "How to traverse C stack: Supported: " + EnumSet.allOf(CStackMode.class) + ".").withRequiredArg().ofType(CStackMode.class).describedAs("mode");
        ArgumentAcceptingOptionSpec<Boolean> optVerbose = parser.accepts("verbose", "Output the sequence of commands.").withRequiredArg().ofType(Boolean.class).defaultsTo(false, (Boolean[])new Boolean[0]).describedAs("bool");
        ArgumentAcceptingOptionSpec<Integer> optTraces = parser.accepts("traces", "Number of top traces to include in the default output.").withRequiredArg().ofType(Integer.class).defaultsTo(200, (Integer[])new Integer[0]).describedAs("int");
        ArgumentAcceptingOptionSpec<Integer> optFlat = parser.accepts("flat", "Number of top flat profiles to include in the default output.").withRequiredArg().ofType(Integer.class).defaultsTo(200, (Integer[])new Integer[0]).describedAs("int");
        OptionSet set = ProfilerUtils.parseInitLine(initLine, parser);
        StringBuilder profilerOptions = new StringBuilder();
        try {
            ProfilerOptionsBuilder builder = new ProfilerOptionsBuilder(set, profilerOptions);
            this.event = (String)optEvent.value(set);
            builder.append(optEvent);
            this.outDir = !set.has(optDir) ? new File(System.getProperty("user.dir")) : new File(set.valueOf(optDir));
            builder.appendIfExists(optInterval);
            builder.appendIfExists(optJstackDepth);
            builder.appendIfTrue(optThreads);
            builder.appendIfTrue(optSimple);
            builder.appendIfTrue(optSig);
            builder.appendIfTrue(optAnn);
            builder.appendIfExists(optFrameBuf);
            if (((Boolean)optFilter.value(set)).booleanValue()) {
                builder.appendRaw("filter");
            }
            builder.appendMulti(optInclude);
            builder.appendMulti(optExclude);
            builder.appendIfExists(optTitle);
            builder.appendIfExists(optWidth);
            builder.appendIfExists(optMinWidth);
            builder.appendIfTrue(optAllKernel);
            builder.appendIfTrue(optAllUser);
            builder.appendIfExists(optCStack);
            if (set.has(optRawCommand)) {
                builder.appendRaw((String)optRawCommand.value(set));
            }
            this.traces = (Integer)optTraces.value(set);
            this.flat = (Integer)optFlat.value(set);
            this.profilerConfig = profilerOptions.toString();
            try {
                this.instance = set.has(optLibPath) ? JavaApi.getInstance((String)optLibPath.value(set)) : JavaApi.getInstance();
            }
            catch (UnsatisfiedLinkError e) {
                throw new ProfilerException("Unable to load async-profiler. Ensure asyncProfiler library is on LD_LIBRARY_PATH, -Djava.library.path or libPath=", e);
            }
            this.direction = (Direction)((Object)optDirection.value(set));
            this.output = optOutput.values(set);
            this.verbose = (Boolean)optVerbose.value(set);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        if (iterationParams.getType() == IterationType.WARMUP && !this.warmupStarted) {
            this.execute("start," + this.profilerConfig);
            this.warmupStarted = true;
        }
        if (iterationParams.getType() == IterationType.MEASUREMENT && !this.measurementStarted) {
            if (this.warmupStarted) {
                this.execute("stop");
            }
            this.execute("start," + this.profilerConfig);
            this.measurementStarted = true;
        }
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult iterationResult) {
        if (iterationParams.getType() == IterationType.MEASUREMENT) {
            ++this.measurementIterationCount;
            if (this.measurementIterationCount == iterationParams.getCount()) {
                File trialOutDir = this.createTrialOutDir(benchmarkParams);
                return Collections.singletonList(this.stopAndDump(trialOutDir));
            }
        }
        return Collections.emptyList();
    }

    private File createTrialOutDir(BenchmarkParams benchmarkParams) {
        String fileName = benchmarkParams.id();
        File trialOutDir = new File(this.outDir, fileName);
        trialOutDir.mkdirs();
        return trialOutDir;
    }

    private TextResult stopAndDump(File trialOutDir) {
        this.execute("stop");
        StringWriter output = new StringWriter();
        PrintWriter pw = new PrintWriter(output);
        for (OutputType outputType : this.output) {
            switch (outputType) {
                case text: {
                    String textOutput = this.dump(trialOutDir, "summary-%s.txt", "summary,flat=" + this.flat + ",traces=" + this.traces);
                    pw.println(textOutput);
                    break;
                }
                case collapsed: {
                    this.dump(trialOutDir, "collapsed-%s.csv", "collapsed");
                    break;
                }
                case flamegraph: {
                    if (this.direction == Direction.both || this.direction == Direction.forward) {
                        this.dump(trialOutDir, "flame-%s-forward.svg", "svg");
                    }
                    if (this.direction != Direction.both && this.direction != Direction.reverse) break;
                    this.dump(trialOutDir, "flame-%s-reverse.svg", "svg,reverse");
                    break;
                }
                case tree: {
                    this.dump(trialOutDir, "tree-%s.html", "tree");
                    break;
                }
                case jfr: {
                    this.dump(trialOutDir, "%s.jfr", "jfr");
                }
            }
        }
        pw.println("Async profiler results:");
        for (File file : this.generated) {
            pw.print("  ");
            pw.println(file.getPath());
        }
        pw.flush();
        pw.close();
        return new TextResult(output.toString(), "async");
    }

    private String dump(File specificOutDir, String fileNameFormatString, String content) {
        File output = new File(specificOutDir, String.format(fileNameFormatString, this.event));
        this.generated.add(output);
        String result = this.execute(content + "," + this.profilerConfig);
        try {
            FileUtils.writeLines(output, Collections.singletonList(result));
            return result;
        }
        catch (IOException e) {
            return "N/A";
        }
    }

    private String execute(String command) {
        if (this.verbose) {
            System.out.println("[async-profiler] " + command);
        }
        try {
            return this.instance.execute(command);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-XX:+UnlockDiagnosticVMOptions");
        args.add("-XX:+DebugNonSafepoints");
        return args;
    }

    @Override
    public void beforeTrial(BenchmarkParams benchmarkParams) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        return Collections.emptyList();
    }

    @Override
    public boolean allowPrintOut() {
        return true;
    }

    @Override
    public boolean allowPrintErr() {
        return true;
    }

    @Override
    public String getDescription() {
        return "async-profiler profiler provider.";
    }

    public static final class JavaApi {
        private static EnumSet<Thread.State> ignoredThreadStates = EnumSet.of(Thread.State.NEW, Thread.State.TERMINATED);
        private static JavaApi INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static JavaApi getInstance(String libraryFileName) {
            if (INSTANCE != null) return INSTANCE;
            Class<AsyncProfiler> clazz = AsyncProfiler.class;
            synchronized (AsyncProfiler.class) {
                INSTANCE = new JavaApi(libraryFileName);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static JavaApi getInstance() {
            if (INSTANCE != null) return INSTANCE;
            Class<AsyncProfiler> clazz = AsyncProfiler.class;
            synchronized (AsyncProfiler.class) {
                INSTANCE = new JavaApi();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        private JavaApi(String libraryFileName) {
            System.load(libraryFileName);
        }

        private JavaApi() {
            System.loadLibrary("asyncProfiler");
        }

        public String execute(String command) throws IOException {
            return this.execute0(command);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void filterThread(Thread thread, boolean enable) {
            if (thread == null) {
                this.filterThread0(null, enable);
            } else {
                Thread thread2 = thread;
                synchronized (thread2) {
                    Thread.State state = thread.getState();
                    if (!ignoredThreadStates.contains((Object)state)) {
                        this.filterThread0(thread, enable);
                    }
                }
            }
        }

        private native void start0(String var1, long var2, boolean var4) throws IllegalStateException;

        private native void stop0() throws IllegalStateException;

        private native String execute0(String var1) throws IllegalArgumentException, IOException;

        private native long getSamples();

        private native void filterThread0(Thread var1, boolean var2);
    }

    private static class ProfilerOptionsBuilder {
        private final OptionSet optionSet;
        private final StringBuilder profilerOptions;

        ProfilerOptionsBuilder(OptionSet optionSet, StringBuilder profilerOptions) {
            this.optionSet = optionSet;
            this.profilerOptions = profilerOptions;
        }

        <T> void appendIfExists(OptionSpec<T> option) {
            if (this.optionSet.has(option)) {
                this.append(option);
            }
        }

        <T> void append(OptionSpec<T> option) {
            assert (option.options().size() == 1);
            String optionName = option.options().iterator().next();
            this.separate();
            this.profilerOptions.append(optionName).append('=').append(this.optionSet.valueOf(option).toString());
        }

        void appendRaw(String command) {
            this.separate();
            this.profilerOptions.append(command);
        }

        private void separate() {
            if (this.profilerOptions.length() > 0) {
                this.profilerOptions.append(',');
            }
        }

        void appendIfTrue(OptionSpec<Boolean> option) {
            if (this.optionSet.has(option) && this.optionSet.valueOf(option).booleanValue()) {
                this.append(option);
            }
        }

        private <T> void appendMulti(OptionSpec<T> option) {
            if (this.optionSet.has(option)) {
                assert (option.options().size() == 1);
                String optionName = option.options().iterator().next();
                for (T value : this.optionSet.valuesOf(option)) {
                    this.profilerOptions.append(',').append(optionName).append('=').append(value.toString());
                }
            }
        }
    }

    public static enum Direction {
        forward,
        reverse,
        both;

    }

    public static enum OutputType {
        text,
        collapsed,
        flamegraph,
        tree,
        jfr;

    }

    public static enum CStackMode {
        fp,
        lbr,
        no;

    }
}

