/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.recording.ResponseDefinitionBodyMatcher;
import com.github.tomakehurst.wiremock.recording.ScenarioProcessor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingBodyExtractor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingTransformerRunner;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class SnapshotStubMappingPostProcessor {
    private final boolean shouldRecordRepeatsAsScenarios;
    private final SnapshotStubMappingTransformerRunner transformerRunner;
    private final ResponseDefinitionBodyMatcher bodyExtractMatcher;
    private final SnapshotStubMappingBodyExtractor bodyExtractor;

    public SnapshotStubMappingPostProcessor(boolean shouldRecordRepeatsAsScenarios, SnapshotStubMappingTransformerRunner transformerRunner, ResponseDefinitionBodyMatcher bodyExtractMatcher, SnapshotStubMappingBodyExtractor bodyExtractor) {
        this.shouldRecordRepeatsAsScenarios = shouldRecordRepeatsAsScenarios;
        this.transformerRunner = transformerRunner;
        this.bodyExtractMatcher = bodyExtractMatcher;
        this.bodyExtractor = bodyExtractor;
    }

    public List<StubMapping> process(Iterable<StubMapping> stubMappings) {
        HashMultiset<RequestPattern> requestCounts = HashMultiset.create();
        ArrayList<StubMapping> processedStubMappings = new ArrayList<StubMapping>();
        for (StubMapping stubMapping : stubMappings) {
            requestCounts.add(stubMapping.getRequest());
            if (requestCounts.count(stubMapping.getRequest()) > 1 && !this.shouldRecordRepeatsAsScenarios) continue;
            if (this.bodyExtractMatcher != null && this.bodyExtractMatcher.match(stubMapping.getResponse()).isExactMatch()) {
                this.bodyExtractor.extractInPlace(stubMapping);
            }
            processedStubMappings.add(stubMapping);
        }
        if (this.shouldRecordRepeatsAsScenarios) {
            new ScenarioProcessor().putRepeatedRequestsInScenarios(processedStubMappings);
        }
        return Lists.transform(processedStubMappings, this.transformerRunner);
    }
}

