/*
 * Decompiled with CFR 0.152.
 */
package rx.observers;

import rx.Observer;
import rx.exceptions.OnErrorNotImplementedException;
import rx.functions.Action0;
import rx.functions.Action1;

public final class Observers {
    private static final Observer<Object> EMPTY = new Observer<Object>(){

        @Override
        public final void onCompleted() {
        }

        @Override
        public final void onError(Throwable e) {
            throw new OnErrorNotImplementedException(e);
        }

        @Override
        public final void onNext(Object args) {
        }
    };

    private Observers() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Observer<T> empty() {
        return EMPTY;
    }

    public static <T> Observer<T> create(final Action1<? super T> onNext) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        return new Observer<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e) {
                throw new OnErrorNotImplementedException(e);
            }

            @Override
            public final void onNext(T args) {
                onNext.call(args);
            }
        };
    }

    public static <T> Observer<T> create(final Action1<? super T> onNext, final Action1<Throwable> onError2) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError2 == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        return new Observer<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e) {
                onError2.call(e);
            }

            @Override
            public final void onNext(T args) {
                onNext.call(args);
            }
        };
    }

    public static <T> Observer<T> create(final Action1<? super T> onNext, final Action1<Throwable> onError2, final Action0 onComplete) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError2 == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        if (onComplete == null) {
            throw new IllegalArgumentException("onComplete can not be null");
        }
        return new Observer<T>(){

            @Override
            public final void onCompleted() {
                onComplete.call();
            }

            @Override
            public final void onError(Throwable e) {
                onError2.call(e);
            }

            @Override
            public final void onNext(T args) {
                onNext.call(args);
            }
        };
    }
}

