/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.operators.BackpressureUtils;

public final class OnSubscribeFromArray<T>
implements Observable.OnSubscribe<T> {
    final T[] array;

    public OnSubscribeFromArray(T[] array) {
        this.array = array;
    }

    @Override
    public void call(Subscriber<? super T> child) {
        child.setProducer(new FromArrayProducer<T>(child, this.array));
    }

    static final class FromArrayProducer<T>
    extends AtomicLong
    implements Producer {
        private static final long serialVersionUID = 3534218984725836979L;
        final Subscriber<? super T> child;
        final T[] array;
        int index;

        public FromArrayProducer(Subscriber<? super T> child, T[] array) {
            this.child = child;
            this.array = array;
        }

        @Override
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required but it was " + n);
            }
            if (n == Long.MAX_VALUE) {
                if (BackpressureUtils.getAndAddRequest(this, n) == 0L) {
                    this.fastPath();
                }
            } else if (n != 0L && BackpressureUtils.getAndAddRequest(this, n) == 0L) {
                this.slowPath(n);
            }
        }

        void fastPath() {
            Subscriber<T> child = this.child;
            for (T t : this.array) {
                if (child.isUnsubscribed()) {
                    return;
                }
                child.onNext(t);
            }
            if (child.isUnsubscribed()) {
                return;
            }
            child.onCompleted();
        }

        void slowPath(long r) {
            Subscriber<T> child = this.child;
            T[] array = this.array;
            int n = array.length;
            long e = 0L;
            int i2 = this.index;
            while (true) {
                if (r != 0L && i2 != n) {
                    if (child.isUnsubscribed()) {
                        return;
                    }
                    child.onNext(array[i2]);
                    if (++i2 == n) {
                        if (!child.isUnsubscribed()) {
                            child.onCompleted();
                        }
                        return;
                    }
                    --r;
                    --e;
                    continue;
                }
                r = this.get() + e;
                if (r != 0L) continue;
                this.index = i2;
                r = this.addAndGet(e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }
}

