/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.net.URI;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.DefaultWebClientBuilder;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientUtils;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultWebClient
implements WebClient {
    private static final String URI_TEMPLATE_ATTRIBUTE = WebClient.class.getName() + ".uriTemplate";
    private static final Mono<ClientResponse> NO_HTTP_CLIENT_RESPONSE_ERROR = Mono.error(new IllegalStateException("The underlying HTTP client completed without emitting a response."));
    private final ExchangeFunction exchangeFunction;
    private final UriBuilderFactory uriBuilderFactory;
    @Nullable
    private final HttpHeaders defaultHeaders;
    @Nullable
    private final MultiValueMap<String, String> defaultCookies;
    @Nullable
    private final Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest;
    private final DefaultWebClientBuilder builder;

    DefaultWebClient(ExchangeFunction exchangeFunction, @Nullable UriBuilderFactory factory, @Nullable HttpHeaders defaultHeaders, @Nullable MultiValueMap<String, String> defaultCookies, @Nullable Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest, DefaultWebClientBuilder builder) {
        this.exchangeFunction = exchangeFunction;
        this.uriBuilderFactory = factory != null ? factory : new DefaultUriBuilderFactory();
        this.defaultHeaders = defaultHeaders;
        this.defaultCookies = defaultCookies;
        this.defaultRequest = defaultRequest;
        this.builder = builder;
    }

    @Override
    public WebClient.RequestHeadersUriSpec<?> get() {
        return this.methodInternal(HttpMethod.GET);
    }

    @Override
    public WebClient.RequestHeadersUriSpec<?> head() {
        return this.methodInternal(HttpMethod.HEAD);
    }

    @Override
    public WebClient.RequestBodyUriSpec post() {
        return this.methodInternal(HttpMethod.POST);
    }

    @Override
    public WebClient.RequestBodyUriSpec put() {
        return this.methodInternal(HttpMethod.PUT);
    }

    @Override
    public WebClient.RequestBodyUriSpec patch() {
        return this.methodInternal(HttpMethod.PATCH);
    }

    @Override
    public WebClient.RequestHeadersUriSpec<?> delete() {
        return this.methodInternal(HttpMethod.DELETE);
    }

    @Override
    public WebClient.RequestHeadersUriSpec<?> options() {
        return this.methodInternal(HttpMethod.OPTIONS);
    }

    @Override
    public WebClient.RequestBodyUriSpec method(HttpMethod httpMethod) {
        return this.methodInternal(httpMethod);
    }

    private WebClient.RequestBodyUriSpec methodInternal(HttpMethod httpMethod) {
        return new DefaultRequestBodyUriSpec(httpMethod);
    }

    @Override
    public WebClient.Builder mutate() {
        return new DefaultWebClientBuilder(this.builder);
    }

    private static class DefaultResponseSpec
    implements WebClient.ResponseSpec {
        private static final IntPredicate STATUS_CODE_ERROR = value -> value >= 400;
        private static final StatusHandler DEFAULT_STATUS_HANDLER = new StatusHandler(STATUS_CODE_ERROR, ClientResponse::createException);
        private final Mono<ClientResponse> responseMono;
        private final Supplier<HttpRequest> requestSupplier;
        private final List<StatusHandler> statusHandlers = new ArrayList<StatusHandler>(1);

        DefaultResponseSpec(Mono<ClientResponse> responseMono, Supplier<HttpRequest> requestSupplier) {
            this.responseMono = responseMono;
            this.requestSupplier = requestSupplier;
            this.statusHandlers.add(DEFAULT_STATUS_HANDLER);
        }

        @Override
        public WebClient.ResponseSpec onStatus(Predicate<HttpStatus> statusPredicate, Function<ClientResponse, Mono<? extends Throwable>> exceptionFunction) {
            return this.onRawStatus(DefaultResponseSpec.toIntPredicate(statusPredicate), exceptionFunction);
        }

        private static IntPredicate toIntPredicate(Predicate<HttpStatus> predicate) {
            return value -> {
                HttpStatus status = HttpStatus.resolve(value);
                return status != null && predicate.test(status);
            };
        }

        @Override
        public WebClient.ResponseSpec onRawStatus(IntPredicate statusCodePredicate, Function<ClientResponse, Mono<? extends Throwable>> exceptionFunction) {
            Assert.notNull((Object)statusCodePredicate, "IntPredicate must not be null");
            Assert.notNull(exceptionFunction, "Function must not be null");
            int index = this.statusHandlers.size() - 1;
            this.statusHandlers.add(index, new StatusHandler(statusCodePredicate, exceptionFunction));
            return this;
        }

        @Override
        public <T> Mono<T> bodyToMono(Class<T> elementClass) {
            Assert.notNull(elementClass, "Class must not be null");
            return this.responseMono.flatMap(response -> this.handleBodyMono((ClientResponse)response, response.bodyToMono(elementClass)));
        }

        @Override
        public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> elementTypeRef) {
            Assert.notNull(elementTypeRef, "ParameterizedTypeReference must not be null");
            return this.responseMono.flatMap(response -> this.handleBodyMono((ClientResponse)response, response.bodyToMono(elementTypeRef)));
        }

        private <T> Mono<T> handleBodyMono(ClientResponse response, Mono<T> bodyPublisher) {
            Mono<T> result = this.statusHandlers(response);
            if (result != null) {
                return result.switchIfEmpty(bodyPublisher);
            }
            return bodyPublisher;
        }

        @Override
        public <T> Flux<T> bodyToFlux(Class<T> elementClass) {
            Assert.notNull(elementClass, "Class must not be null");
            return this.responseMono.flatMapMany(response -> this.handleBodyFlux((ClientResponse)response, response.bodyToFlux(elementClass)));
        }

        @Override
        public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> elementTypeRef) {
            Assert.notNull(elementTypeRef, "ParameterizedTypeReference must not be null");
            return this.responseMono.flatMapMany(response -> this.handleBodyFlux((ClientResponse)response, response.bodyToFlux(elementTypeRef)));
        }

        private <T> Publisher<T> handleBodyFlux(ClientResponse response, Flux<T> bodyPublisher) {
            Mono<T> result = this.statusHandlers(response);
            if (result != null) {
                return result.flux().switchIfEmpty(bodyPublisher);
            }
            return bodyPublisher;
        }

        @Nullable
        private <T> Mono<T> statusHandlers(ClientResponse response) {
            int statusCode = response.rawStatusCode();
            for (StatusHandler handler : this.statusHandlers) {
                Mono<Throwable> exMono;
                if (!handler.test(statusCode)) continue;
                try {
                    exMono = handler.apply(response);
                    exMono = exMono.flatMap(ex -> this.drainBody(response, (Throwable)ex));
                    exMono = exMono.onErrorResume(ex -> this.drainBody(response, (Throwable)ex));
                }
                catch (Throwable ex2) {
                    exMono = this.drainBody(response, ex2);
                }
                Mono result = exMono.flatMap(Mono::error);
                HttpRequest request = this.requestSupplier.get();
                return this.insertCheckpoint(result, statusCode, request);
            }
            return null;
        }

        private <T> Mono<T> drainBody(ClientResponse response, Throwable ex) {
            return response.releaseBody().onErrorResume(ex2 -> Mono.empty()).thenReturn(ex);
        }

        private <T> Mono<T> insertCheckpoint(Mono<T> result, int statusCode, HttpRequest request) {
            String httpMethod = request.getMethodValue();
            URI uri = request.getURI();
            String description = statusCode + " from " + httpMethod + " " + uri + " [DefaultWebClient]";
            return result.checkpoint(description);
        }

        @Override
        public <T> Mono<ResponseEntity<T>> toEntity(Class<T> bodyClass) {
            return this.responseMono.flatMap(response -> WebClientUtils.mapToEntity(response, this.handleBodyMono((ClientResponse)response, response.bodyToMono(bodyClass))));
        }

        @Override
        public <T> Mono<ResponseEntity<T>> toEntity(ParameterizedTypeReference<T> bodyTypeRef) {
            return this.responseMono.flatMap(response -> WebClientUtils.mapToEntity(response, this.handleBodyMono((ClientResponse)response, response.bodyToMono(bodyTypeRef))));
        }

        @Override
        public <T> Mono<ResponseEntity<List<T>>> toEntityList(Class<T> elementClass) {
            return this.responseMono.flatMap(response -> WebClientUtils.mapToEntityList(response, this.handleBodyFlux((ClientResponse)response, response.bodyToFlux(elementClass))));
        }

        @Override
        public <T> Mono<ResponseEntity<List<T>>> toEntityList(ParameterizedTypeReference<T> elementTypeRef) {
            return this.responseMono.flatMap(response -> WebClientUtils.mapToEntityList(response, this.handleBodyFlux((ClientResponse)response, response.bodyToFlux(elementTypeRef))));
        }

        @Override
        public Mono<ResponseEntity<Void>> toBodilessEntity() {
            return this.responseMono.flatMap(response -> WebClientUtils.mapToEntity(response, this.handleBodyMono((ClientResponse)response, Mono.empty())).flatMap(entity -> response.releaseBody().thenReturn(entity)));
        }

        private static class StatusHandler {
            private final IntPredicate predicate;
            private final Function<ClientResponse, Mono<? extends Throwable>> exceptionFunction;

            public StatusHandler(IntPredicate predicate, Function<ClientResponse, Mono<? extends Throwable>> exceptionFunction) {
                this.predicate = predicate;
                this.exceptionFunction = exceptionFunction;
            }

            public boolean test(int status) {
                return this.predicate.test(status);
            }

            public Mono<? extends Throwable> apply(ClientResponse response) {
                return this.exceptionFunction.apply(response);
            }
        }
    }

    private class DefaultRequestBodyUriSpec
    implements WebClient.RequestBodyUriSpec {
        private final HttpMethod httpMethod;
        @Nullable
        private URI uri;
        @Nullable
        private HttpHeaders headers;
        @Nullable
        private MultiValueMap<String, String> cookies;
        @Nullable
        private BodyInserter<?, ? super ClientHttpRequest> inserter;
        private final Map<String, Object> attributes = new LinkedHashMap<String, Object>(4);

        DefaultRequestBodyUriSpec(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public WebClient.RequestBodySpec uri(String uriTemplate, Object ... uriVariables) {
            this.attribute(URI_TEMPLATE_ATTRIBUTE, uriTemplate);
            return this.uri(DefaultWebClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public WebClient.RequestBodySpec uri(String uriTemplate, Map<String, ?> uriVariables) {
            this.attribute(URI_TEMPLATE_ATTRIBUTE, uriTemplate);
            return this.uri(DefaultWebClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public WebClient.RequestBodySpec uri(String uriTemplate, Function<UriBuilder, URI> uriFunction) {
            this.attribute(URI_TEMPLATE_ATTRIBUTE, uriTemplate);
            return this.uri(uriFunction.apply(DefaultWebClient.this.uriBuilderFactory.uriString(uriTemplate)));
        }

        @Override
        public WebClient.RequestBodySpec uri(Function<UriBuilder, URI> uriFunction) {
            return this.uri(uriFunction.apply(DefaultWebClient.this.uriBuilderFactory.builder()));
        }

        @Override
        public WebClient.RequestBodySpec uri(URI uri) {
            this.uri = uri;
            return this;
        }

        private HttpHeaders getHeaders() {
            if (this.headers == null) {
                this.headers = new HttpHeaders();
            }
            return this.headers;
        }

        private MultiValueMap<String, String> getCookies() {
            if (this.cookies == null) {
                this.cookies = new LinkedMultiValueMap<String, String>(4);
            }
            return this.cookies;
        }

        @Override
        public DefaultRequestBodyUriSpec header(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.getHeaders().add(headerName, headerValue);
            }
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec headers(Consumer<HttpHeaders> headersConsumer) {
            headersConsumer.accept(this.getHeaders());
            return this;
        }

        @Override
        public WebClient.RequestBodySpec attribute(String name, Object value) {
            this.attributes.put(name, value);
            return this;
        }

        @Override
        public WebClient.RequestBodySpec attributes(Consumer<Map<String, Object>> attributesConsumer) {
            attributesConsumer.accept(this.attributes);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec accept(MediaType ... acceptableMediaTypes) {
            this.getHeaders().setAccept(Arrays.asList(acceptableMediaTypes));
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec acceptCharset(Charset ... acceptableCharsets) {
            this.getHeaders().setAcceptCharset(Arrays.asList(acceptableCharsets));
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec contentType(MediaType contentType2) {
            this.getHeaders().setContentType(contentType2);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec contentLength(long contentLength) {
            this.getHeaders().setContentLength(contentLength);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec cookie(String name, String value) {
            this.getCookies().add(name, value);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec cookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
            cookiesConsumer.accept(this.getCookies());
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec ifModifiedSince(ZonedDateTime ifModifiedSince) {
            this.getHeaders().setIfModifiedSince(ifModifiedSince);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec ifNoneMatch(String ... ifNoneMatches) {
            this.getHeaders().setIfNoneMatch(Arrays.asList(ifNoneMatches));
            return this;
        }

        @Override
        public WebClient.RequestHeadersSpec<?> bodyValue(Object body2) {
            this.inserter = BodyInserters.fromValue(body2);
            return this;
        }

        @Override
        public <T, P extends Publisher<T>> WebClient.RequestHeadersSpec<?> body(P publisher, ParameterizedTypeReference<T> elementTypeRef) {
            this.inserter = BodyInserters.fromPublisher(publisher, elementTypeRef);
            return this;
        }

        @Override
        public <T, P extends Publisher<T>> WebClient.RequestHeadersSpec<?> body(P publisher, Class<T> elementClass) {
            this.inserter = BodyInserters.fromPublisher(publisher, elementClass);
            return this;
        }

        @Override
        public WebClient.RequestHeadersSpec<?> body(Object producer, Class<?> elementClass) {
            this.inserter = BodyInserters.fromProducer(producer, elementClass);
            return this;
        }

        @Override
        public WebClient.RequestHeadersSpec<?> body(Object producer, ParameterizedTypeReference<?> elementTypeRef) {
            this.inserter = BodyInserters.fromProducer(producer, elementTypeRef);
            return this;
        }

        @Override
        public WebClient.RequestHeadersSpec<?> body(BodyInserter<?, ? super ClientHttpRequest> inserter) {
            this.inserter = inserter;
            return this;
        }

        @Override
        @Deprecated
        public WebClient.RequestHeadersSpec<?> syncBody(Object body2) {
            return this.bodyValue(body2);
        }

        @Override
        public Mono<ClientResponse> exchange() {
            ClientRequest request = this.inserter != null ? this.initRequestBuilder().body(this.inserter).build() : this.initRequestBuilder().build();
            return Mono.defer(() -> DefaultWebClient.this.exchangeFunction.exchange(request).checkpoint("Request to " + this.httpMethod.name() + " " + this.uri + " [DefaultWebClient]").switchIfEmpty(NO_HTTP_CLIENT_RESPONSE_ERROR));
        }

        private ClientRequest.Builder initRequestBuilder() {
            if (DefaultWebClient.this.defaultRequest != null) {
                DefaultWebClient.this.defaultRequest.accept(this);
            }
            return ClientRequest.create(this.httpMethod, this.initUri()).headers((HttpHeaders headers2) -> headers2.addAll(this.initHeaders())).cookies((MultiValueMap<String, String> cookies) -> cookies.addAll(this.initCookies())).attributes((Map<String, Object> attributes) -> attributes.putAll(this.attributes));
        }

        private URI initUri() {
            return this.uri != null ? this.uri : DefaultWebClient.this.uriBuilderFactory.expand("", new Object[0]);
        }

        private HttpHeaders initHeaders() {
            if (CollectionUtils.isEmpty(this.headers)) {
                return DefaultWebClient.this.defaultHeaders != null ? DefaultWebClient.this.defaultHeaders : new HttpHeaders();
            }
            if (CollectionUtils.isEmpty(DefaultWebClient.this.defaultHeaders)) {
                return this.headers;
            }
            HttpHeaders result = new HttpHeaders();
            result.putAll(DefaultWebClient.this.defaultHeaders);
            result.putAll(this.headers);
            return result;
        }

        private MultiValueMap<String, String> initCookies() {
            if (CollectionUtils.isEmpty(this.cookies)) {
                return DefaultWebClient.this.defaultCookies != null ? DefaultWebClient.this.defaultCookies : new LinkedMultiValueMap();
            }
            if (CollectionUtils.isEmpty(DefaultWebClient.this.defaultCookies)) {
                return this.cookies;
            }
            LinkedMultiValueMap<String, String> result = new LinkedMultiValueMap<String, String>();
            result.putAll(DefaultWebClient.this.defaultCookies);
            result.putAll((Map<String, String>)this.cookies);
            return result;
        }

        @Override
        public WebClient.ResponseSpec retrieve() {
            return new DefaultResponseSpec(this.exchange(), this::createRequest);
        }

        private HttpRequest createRequest() {
            return new HttpRequest(){
                private final URI uri;
                private final HttpHeaders headers;
                {
                    this.uri = DefaultRequestBodyUriSpec.this.initUri();
                    this.headers = DefaultRequestBodyUriSpec.this.initHeaders();
                }

                @Override
                public HttpMethod getMethod() {
                    return DefaultRequestBodyUriSpec.this.httpMethod;
                }

                @Override
                public String getMethodValue() {
                    return DefaultRequestBodyUriSpec.this.httpMethod.name();
                }

                @Override
                public URI getURI() {
                    return this.uri;
                }

                @Override
                public HttpHeaders getHeaders() {
                    return this.headers;
                }
            };
        }
    }
}

