/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;

public class SortedConcurrentMappingSet
implements Iterable<StubMapping> {
    private AtomicLong insertionCount = new AtomicLong();
    private ConcurrentSkipListSet<StubMapping> mappingSet = new ConcurrentSkipListSet<StubMapping>(this.sortedByPriorityThenReverseInsertionOrder());

    private Comparator<StubMapping> sortedByPriorityThenReverseInsertionOrder() {
        return new Comparator<StubMapping>(){

            @Override
            public int compare(StubMapping one, StubMapping two) {
                int priorityComparison = one.comparePriorityWith(two);
                if (priorityComparison != 0) {
                    return priorityComparison;
                }
                return Long.compare(two.getInsertionIndex(), one.getInsertionIndex());
            }
        };
    }

    @Override
    public Iterator<StubMapping> iterator() {
        return this.mappingSet.iterator();
    }

    public void add(StubMapping mapping) {
        mapping.setInsertionIndex(this.insertionCount.getAndIncrement());
        this.mappingSet.add(mapping);
    }

    public boolean remove(final StubMapping mappingToRemove) {
        boolean removedByUuid = Iterables.removeIf(this.mappingSet, new Predicate<StubMapping>(){

            @Override
            public boolean apply(StubMapping mapping) {
                return mappingToRemove.getUuid() != null && mapping.getUuid() != null && mappingToRemove.getUuid().equals(mapping.getUuid());
            }
        });
        boolean removedByRequestPattern = !removedByUuid && Iterables.removeIf(this.mappingSet, new Predicate<StubMapping>(){

            @Override
            public boolean apply(StubMapping mapping) {
                return mappingToRemove.getRequest().equals(mapping.getRequest());
            }
        });
        return removedByUuid || removedByRequestPattern;
    }

    public boolean replace(StubMapping existingStubMapping, StubMapping newStubMapping) {
        if (this.mappingSet.remove(existingStubMapping)) {
            this.mappingSet.add(newStubMapping);
            return true;
        }
        return false;
    }

    public void clear() {
        this.mappingSet.clear();
    }

    public String toString() {
        return this.mappingSet.toString();
    }
}

