/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class ProxySettings {
    public static final ProxySettings NO_PROXY = new ProxySettings(null, 0);
    public static final int DEFAULT_PORT = 80;
    private final String host;
    private final int port;
    private String username;
    private String password;

    public ProxySettings(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static ProxySettings fromString(String config) {
        try {
            URL proxyUrl;
            try {
                proxyUrl = new URL(config);
            }
            catch (MalformedURLException e) {
                config = "http://" + config;
                proxyUrl = new URL(config);
            }
            if (!"http".equals(proxyUrl.getProtocol())) {
                throw new IllegalArgumentException("Proxy via does not support any other protocol than http");
            }
            Preconditions.checkArgument(!proxyUrl.getHost().isEmpty(), "Host part of proxy must be specified");
            ProxySettings proxySettings = new ProxySettings(proxyUrl.getHost(), proxyUrl.getPort() == -1 ? 80 : proxyUrl.getPort());
            if (!StringUtils.isEmpty(proxyUrl.getUserInfo())) {
                String[] userInfoArray = proxyUrl.getUserInfo().split(":");
                proxySettings.setUsername(userInfoArray[0]);
                if (userInfoArray.length > 1) {
                    proxySettings.setPassword(userInfoArray[1]);
                }
            }
            return proxySettings;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Proxy via Url %s was not recognized", config), e);
        }
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        if (this == NO_PROXY) {
            return "(no proxy)";
        }
        return String.format("%s:%s%s", this.host(), this.port(), !StringUtils.isEmpty(this.username) ? " (with credentials)" : "");
    }
}

