/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.AttributeKey;
import io.netty.util.NetUtil;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.NettyInbound;
import reactor.netty.NettyOutbound;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.MicrometerChannelMetricsRecorder;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.InetSocketAddressUtil;
import reactor.netty.tcp.ProxyProvider;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpClientBootstrap;
import reactor.netty.tcp.TcpClientConnect;
import reactor.netty.tcp.TcpClientDoOn;
import reactor.netty.tcp.TcpClientObserve;
import reactor.netty.tcp.TcpClientProxy;
import reactor.netty.tcp.TcpClientRunOn;
import reactor.netty.tcp.TcpClientSecure;
import reactor.netty.tcp.TcpClientUnproxy;
import reactor.netty.tcp.TcpClientUnsecure;
import reactor.netty.tcp.TcpResources;
import reactor.netty.tcp.TcpUtils;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.Metrics;

public abstract class TcpClient {
    static final int DEFAULT_PORT = System.getenv("PORT") != null ? Integer.parseInt(System.getenv("PORT")) : 12012;
    static final Bootstrap DEFAULT_BOOTSTRAP = ((Bootstrap)new Bootstrap().option(ChannelOption.AUTO_READ, false)).remoteAddress(InetSocketAddressUtil.createUnresolved(NetUtil.LOCALHOST.getHostAddress(), DEFAULT_PORT));
    static final LoggingHandler LOGGING_HANDLER;
    static final Logger log;

    public static TcpClient create() {
        return TcpClient.create(TcpResources.get());
    }

    public static TcpClient create(ConnectionProvider provider) {
        return new TcpClientConnect(provider);
    }

    public static TcpClient newConnection() {
        return TcpClientConnect.INSTANCE;
    }

    @Deprecated
    public final TcpClient addressSupplier(Supplier<? extends SocketAddress> connectAddressSupplier) {
        return this.remoteAddress(connectAddressSupplier);
    }

    public final TcpClient remoteAddress(Supplier<? extends SocketAddress> remoteAddressSupplier) {
        TcpUtils.SocketAddressSupplier lazy = TcpUtils.lazyAddress(remoteAddressSupplier);
        return this.bootstrap(b -> b.remoteAddress(lazy));
    }

    public final <T> TcpClient attr(AttributeKey<T> key, @Nullable T value) {
        Objects.requireNonNull(key, "key");
        return this.bootstrap(b -> (Bootstrap)b.attr(key, value));
    }

    public final TcpClient bindAddress(Supplier<? extends SocketAddress> bindAddressSupplier) {
        Objects.requireNonNull(bindAddressSupplier, "bindAddressSupplier");
        return this.bootstrap(b -> (Bootstrap)b.localAddress((SocketAddress)bindAddressSupplier.get()));
    }

    @Deprecated
    public final TcpClient bootstrap(Function<? super Bootstrap, ? extends Bootstrap> bootstrapMapper) {
        return new TcpClientBootstrap(this, bootstrapMapper);
    }

    public Bootstrap configure() {
        return DEFAULT_BOOTSTRAP.clone();
    }

    public final Mono<? extends Connection> connect() {
        Bootstrap b;
        try {
            b = this.configure();
        }
        catch (Throwable t) {
            Exceptions.throwIfJvmFatal(t);
            return Mono.error(t);
        }
        return this.connect(b);
    }

    public abstract Mono<? extends Connection> connect(Bootstrap var1);

    public final Connection connectNow() {
        return this.connectNow(Duration.ofSeconds(45L));
    }

    public final Connection connectNow(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        try {
            return Objects.requireNonNull(this.connect().block(timeout), "aborted");
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("blocking read")) {
                throw new IllegalStateException("TcpClient couldn't be started within " + timeout.toMillis() + "ms");
            }
            throw e;
        }
    }

    public final TcpClient doOnConnect(Consumer<? super Bootstrap> doOnConnect) {
        Objects.requireNonNull(doOnConnect, "doOnConnect");
        return new TcpClientDoOn(this, doOnConnect, null, null);
    }

    public final TcpClient doOnConnected(Consumer<? super Connection> doOnConnected) {
        Objects.requireNonNull(doOnConnected, "doOnConnected");
        return new TcpClientDoOn(this, null, doOnConnected, null);
    }

    public final TcpClient doOnDisconnected(Consumer<? super Connection> doOnDisconnected) {
        Objects.requireNonNull(doOnDisconnected, "doOnDisconnected");
        return new TcpClientDoOn(this, null, null, doOnDisconnected);
    }

    @Deprecated
    public final TcpClient doOnLifecycle(Consumer<? super Bootstrap> doOnConnect, Consumer<? super Connection> doOnConnected, Consumer<? super Connection> doOnDisconnected) {
        Objects.requireNonNull(doOnConnect, "doOnConnect");
        Objects.requireNonNull(doOnConnected, "doOnConnected");
        Objects.requireNonNull(doOnDisconnected, "doOnDisconnected");
        return new TcpClientDoOn(this, doOnConnect, doOnConnected, doOnDisconnected);
    }

    public final TcpClient host(String host) {
        Objects.requireNonNull(host, "host");
        return this.bootstrap(b -> TcpUtils.updateHost(b, host));
    }

    public final TcpClient handle(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.doOnConnected(c -> {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(c.channel(), "Handler is being applied: {}"), handler);
            }
            Mono.fromDirect((Publisher)handler.apply((NettyInbound)((Object)c), (NettyOutbound)((Object)c))).subscribe(c.disposeSubscriber());
        });
    }

    public final boolean hasProxy() {
        return this.proxyProvider() != null;
    }

    public final boolean isSecure() {
        return this.sslProvider() != null;
    }

    public final TcpClient noProxy() {
        return new TcpClientUnproxy(this);
    }

    public final TcpClient noSSL() {
        return new TcpClientUnsecure(this);
    }

    public final TcpClient observe(ConnectionObserver observer) {
        return new TcpClientObserve(this, observer);
    }

    public final <T> TcpClient option(ChannelOption<T> key, @Nullable T value) {
        Objects.requireNonNull(key, "key");
        return this.bootstrap(b -> (Bootstrap)b.option(key, value));
    }

    public final TcpClient port(int port) {
        return this.bootstrap(b -> TcpUtils.updatePort(b, port));
    }

    public final TcpClient proxy(Consumer<? super ProxyProvider.TypeSpec> proxyOptions) {
        return new TcpClientProxy(this, proxyOptions);
    }

    @Nullable
    public ProxyProvider proxyProvider() {
        return null;
    }

    public final TcpClient resolver(AddressResolverGroup<?> resolver) {
        Objects.requireNonNull(resolver, "resolver");
        return this.bootstrap(b -> b.resolver(resolver));
    }

    public final TcpClient runOn(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        return this.runOn((boolean preferNative) -> eventLoopGroup);
    }

    public final TcpClient runOn(LoopResources channelResources) {
        return this.runOn(channelResources, LoopResources.DEFAULT_NATIVE);
    }

    public final TcpClient runOn(LoopResources channelResources, boolean preferNative) {
        return new TcpClientRunOn(this, channelResources, preferNative);
    }

    public final TcpClient secure() {
        return new TcpClientSecure(this, null);
    }

    public final TcpClient secure(Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder) {
        return TcpClientSecure.secure(this, sslProviderBuilder);
    }

    public final TcpClient secure(SslProvider sslProvider) {
        return new TcpClientSecure(this, sslProvider);
    }

    @Nullable
    public SslProvider sslProvider() {
        return null;
    }

    public final TcpClient metrics(boolean metricsEnabled) {
        if (metricsEnabled) {
            if (!Metrics.isInstrumentationAvailable()) {
                throw new UnsupportedOperationException("To enable metrics, you must add the dependency `io.micrometer:micrometer-core` to the class path first");
            }
            return this.bootstrap(b -> BootstrapHandlers.updateMetricsSupport(b, (ChannelMetricsRecorder)MicrometerTcpClientMetricsRecorder.INSTANCE));
        }
        return this.bootstrap(BootstrapHandlers::removeMetricsSupport);
    }

    @Deprecated
    public final TcpClient metrics(boolean metricsEnabled, ChannelMetricsRecorder recorder) {
        if (metricsEnabled) {
            Objects.requireNonNull(recorder, "recorder");
            return this.bootstrap(b -> BootstrapHandlers.updateMetricsSupport(b, recorder));
        }
        return this.bootstrap(BootstrapHandlers::removeMetricsSupport);
    }

    public final TcpClient metrics(boolean metricsEnabled, Supplier<? extends ChannelMetricsRecorder> recorder) {
        if (metricsEnabled) {
            Objects.requireNonNull(recorder, "recorder");
            return this.bootstrap(b -> BootstrapHandlers.updateMetricsSupport(b, (ChannelMetricsRecorder)recorder.get()));
        }
        return this.bootstrap(BootstrapHandlers::removeMetricsSupport);
    }

    public final TcpClient wiretap(boolean enable) {
        if (enable) {
            return this.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, LOGGING_HANDLER));
        }
        return this.bootstrap(b -> BootstrapHandlers.removeConfiguration(b, "reactor.left.loggingHandler"));
    }

    public final TcpClient wiretap(String category) {
        return this.wiretap(category, LogLevel.DEBUG);
    }

    public final TcpClient wiretap(String category, LogLevel level) {
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(level, "level");
        return this.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, category, level));
    }

    static {
        BootstrapHandlers.channelOperationFactory(DEFAULT_BOOTSTRAP, TcpUtils.TCP_OPS);
        LOGGING_HANDLER = new LoggingHandler(TcpClient.class);
        log = Loggers.getLogger(TcpClient.class);
    }

    static final class MicrometerTcpClientMetricsRecorder
    extends MicrometerChannelMetricsRecorder {
        static final MicrometerTcpClientMetricsRecorder INSTANCE = new MicrometerTcpClientMetricsRecorder("reactor.netty.tcp.client", "tcp");

        MicrometerTcpClientMetricsRecorder(String name, String protocol) {
            super(name, protocol);
        }
    }
}

