/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.helper.I18nSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.lang3.Validate;

class DefI18nSource
implements I18nSource {
    private ResourceBundle bundle;

    public DefI18nSource(Charset charset, String baseName, Locale locale, ClassLoader classLoader) {
        this.bundle = ResourceBundle.getBundle(baseName, locale, classLoader, new UTF8Control(charset));
    }

    @Override
    public String[] keys(String basename, Locale locale) {
        Enumeration<String> keys = this.bundle.getKeys();
        ArrayList<String> result = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            result.add(key);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String message(String key, Locale locale, Object ... args) {
        Validate.isTrue(this.bundle.containsKey(key), "no message found: '%s' for locale '%s'.", key, locale);
        String message = this.bundle.getString(key);
        if (args.length == 0) {
            return message;
        }
        MessageFormat format = new MessageFormat(message, locale);
        return format.format(args);
    }

    public static class UTF8Control
    extends ResourceBundle.Control {
        private final Charset charset;

        public UTF8Control(Charset charset) {
            this.charset = charset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            try (InputStream stream = null;){
                PropertyResourceBundle bundle;
                stream = loader.getResourceAsStream(resourceName);
                PropertyResourceBundle propertyResourceBundle = bundle = new PropertyResourceBundle(new InputStreamReader(stream, this.charset));
                return propertyResourceBundle;
            }
        }
    }
}

