/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.Channel;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.BiFunction;
import reactor.util.annotation.Nullable;

public final class ConnectionInfo {
    final InetSocketAddress hostAddress;
    final InetSocketAddress remoteAddress;
    final String scheme;

    static ConnectionInfo from(Channel channel, HttpRequest request, boolean secured, SocketAddress remoteAddress, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler) {
        if (!(remoteAddress instanceof InetSocketAddress)) {
            return null;
        }
        ConnectionInfo connectionInfo = ConnectionInfo.newConnectionInfo(channel, secured, (InetSocketAddress)remoteAddress);
        if (forwardedHeaderHandler != null) {
            return forwardedHeaderHandler.apply(connectionInfo, request);
        }
        return connectionInfo;
    }

    static ConnectionInfo newConnectionInfo(Channel c, boolean secured, InetSocketAddress remoteAddress) {
        SocketChannel channel = (SocketChannel)c;
        InetSocketAddress hostAddress = channel.localAddress();
        String scheme = secured ? "https" : "http";
        return new ConnectionInfo(hostAddress, remoteAddress, scheme);
    }

    ConnectionInfo(InetSocketAddress hostAddress, InetSocketAddress remoteAddress, String scheme) {
        this.hostAddress = hostAddress;
        this.remoteAddress = remoteAddress;
        this.scheme = scheme;
    }

    public InetSocketAddress getHostAddress() {
        return this.hostAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getScheme() {
        return this.scheme;
    }

    public ConnectionInfo withHostAddress(InetSocketAddress hostAddress) {
        return new ConnectionInfo(hostAddress, this.remoteAddress, this.scheme);
    }

    public ConnectionInfo withRemoteAddress(InetSocketAddress remoteAddress) {
        return new ConnectionInfo(this.hostAddress, remoteAddress, this.scheme);
    }

    public ConnectionInfo withScheme(String scheme) {
        return new ConnectionInfo(this.hostAddress, this.remoteAddress, scheme);
    }
}

