/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveOptions;
import reactivefeign.webclient.CustomizableWebClientBuilder;
import reactivefeign.webclient.WebClientFeignCustomizer;
import reactivefeign.webclient.WebReactiveOptions;
import reactivefeign.webclient.client.WebReactiveHttpClient;

public class WebReactiveFeign {
    public static <T> Builder<T> builder() {
        return WebReactiveFeign.builder(WebClient.builder());
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder) {
        return new Builder(webClientBuilder);
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
        return new Builder(webClientBuilder, webClientCustomizer);
    }

    public static class Builder<T>
    extends ReactiveFeign.Builder<T> {
        protected CustomizableWebClientBuilder webClientBuilder;

        protected Builder(WebClient.Builder webClientBuilder) {
            this.webClientBuilder = new CustomizableWebClientBuilder(webClientBuilder);
            this.updateClientFactory();
        }

        protected Builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
            this.webClientBuilder = new CustomizableWebClientBuilder(webClientBuilder);
            webClientCustomizer.accept(this.webClientBuilder);
            this.updateClientFactory();
        }

        @Override
        public Builder<T> options(ReactiveOptions options) {
            this.webClientBuilder.setWebOptions((WebReactiveOptions)options);
            this.updateClientFactory();
            return this;
        }

        protected void updateClientFactory() {
            this.clientFactory(methodMetadata -> WebReactiveHttpClient.webClient(methodMetadata, this.webClientBuilder.build()));
        }
    }
}

