/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.CompositeException;
import rx.functions.Action0;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.atomic.SpscLinkedArrayQueue;
import rx.plugins.RxJavaHooks;
import rx.subscriptions.SerialSubscription;
import rx.subscriptions.Subscriptions;

public final class OperatorSwitch<T>
implements Observable.Operator<T, Observable<? extends T>> {
    final boolean delayError;

    public static <T> OperatorSwitch<T> instance(boolean delayError) {
        if (delayError) {
            return HolderDelayError.INSTANCE;
        }
        return Holder.INSTANCE;
    }

    OperatorSwitch(boolean delayError) {
        this.delayError = delayError;
    }

    @Override
    public Subscriber<? super Observable<? extends T>> call(Subscriber<? super T> child) {
        SwitchSubscriber<T> sws = new SwitchSubscriber<T>(child, this.delayError);
        child.add(sws);
        sws.init();
        return sws;
    }

    static final class InnerSubscriber<T>
    extends Subscriber<T> {
        private final long id;
        private final SwitchSubscriber<T> parent;

        InnerSubscriber(long id, SwitchSubscriber<T> parent) {
            this.id = id;
            this.parent = parent;
        }

        @Override
        public void setProducer(Producer p) {
            this.parent.innerProducer(p, this.id);
        }

        @Override
        public void onNext(T t) {
            this.parent.emit(t, this);
        }

        @Override
        public void onError(Throwable e) {
            this.parent.error(e, this.id);
        }

        @Override
        public void onCompleted() {
            this.parent.complete(this.id);
        }
    }

    static final class SwitchSubscriber<T>
    extends Subscriber<Observable<? extends T>> {
        final Subscriber<? super T> child;
        final SerialSubscription serial;
        final boolean delayError;
        final AtomicLong index;
        final SpscLinkedArrayQueue<Object> queue;
        boolean emitting;
        boolean missed;
        long requested;
        Producer producer;
        volatile boolean mainDone;
        Throwable error;
        boolean innerActive;
        static final Throwable TERMINAL_ERROR = new Throwable("Terminal error");

        SwitchSubscriber(Subscriber<? super T> child, boolean delayError) {
            this.child = child;
            this.serial = new SerialSubscription();
            this.delayError = delayError;
            this.index = new AtomicLong();
            this.queue = new SpscLinkedArrayQueue(RxRingBuffer.SIZE);
        }

        void init() {
            this.child.add(this.serial);
            this.child.add(Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    SwitchSubscriber.this.clearProducer();
                }
            }));
            this.child.setProducer(new Producer(){

                @Override
                public void request(long n) {
                    if (n > 0L) {
                        SwitchSubscriber.this.childRequested(n);
                    } else if (n < 0L) {
                        throw new IllegalArgumentException("n >= 0 expected but it was " + n);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearProducer() {
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                this.producer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(Observable<? extends T> t) {
            InnerSubscriber inner;
            long id = this.index.incrementAndGet();
            Subscription s2 = this.serial.get();
            if (s2 != null) {
                s2.unsubscribe();
            }
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                inner = new InnerSubscriber(id, this);
                this.innerActive = true;
                this.producer = null;
            }
            this.serial.set(inner);
            t.unsafeSubscribe(inner);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            boolean success;
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                success = this.updateError(e);
            }
            if (success) {
                this.mainDone = true;
                this.drain();
            } else {
                this.pluginError(e);
            }
        }

        boolean updateError(Throwable next) {
            Throwable e = this.error;
            if (e == TERMINAL_ERROR) {
                return false;
            }
            if (e == null) {
                this.error = next;
            } else if (e instanceof CompositeException) {
                ArrayList<Throwable> list = new ArrayList<Throwable>(((CompositeException)e).getExceptions());
                list.add(next);
                this.error = new CompositeException(list);
            } else {
                this.error = new CompositeException(e, next);
            }
            return true;
        }

        @Override
        public void onCompleted() {
            this.mainDone = true;
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emit(T value, InnerSubscriber<T> inner) {
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                if (this.index.get() != ((InnerSubscriber)inner).id) {
                    return;
                }
                this.queue.offer(inner, NotificationLite.next(value));
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void error(Throwable e, long id) {
            boolean success;
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                if (this.index.get() == id) {
                    success = this.updateError(e);
                    this.innerActive = false;
                    this.producer = null;
                } else {
                    success = true;
                }
            }
            if (success) {
                this.drain();
            } else {
                this.pluginError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete(long id) {
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                if (this.index.get() != id) {
                    return;
                }
                this.innerActive = false;
                this.producer = null;
            }
            this.drain();
        }

        void pluginError(Throwable e) {
            RxJavaHooks.onError(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerProducer(Producer p, long id) {
            long n;
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                if (this.index.get() != id) {
                    return;
                }
                n = this.requested;
                this.producer = p;
            }
            p.request(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void childRequested(long n) {
            Producer p;
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                p = this.producer;
                this.requested = BackpressureUtils.addCap(this.requested, n);
            }
            if (p != null) {
                p.request(n);
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drain() {
            Throwable localError;
            long localRequested;
            boolean localInnerActive;
            SwitchSubscriber switchSubscriber = this;
            synchronized (switchSubscriber) {
                if (this.emitting) {
                    this.missed = true;
                    return;
                }
                this.emitting = true;
                localInnerActive = this.innerActive;
                localRequested = this.requested;
                localError = this.error;
                if (localError != null && localError != TERMINAL_ERROR && !this.delayError) {
                    this.error = TERMINAL_ERROR;
                }
            }
            SpscLinkedArrayQueue<Object> localQueue = this.queue;
            AtomicLong localIndex = this.index;
            Subscriber localChild = this.child;
            boolean localMainDone = this.mainDone;
            while (true) {
                long localEmission = 0L;
                while (localEmission != localRequested) {
                    if (localChild.isUnsubscribed()) {
                        return;
                    }
                    boolean empty = localQueue.isEmpty();
                    if (this.checkTerminated(localMainDone, localInnerActive, localError, localQueue, localChild, empty)) {
                        return;
                    }
                    if (empty) break;
                    InnerSubscriber inner = (InnerSubscriber)localQueue.poll();
                    Object value = NotificationLite.getValue(localQueue.poll());
                    if (localIndex.get() != inner.id) continue;
                    localChild.onNext(value);
                    ++localEmission;
                }
                if (localEmission == localRequested) {
                    if (localChild.isUnsubscribed()) {
                        return;
                    }
                    if (this.checkTerminated(this.mainDone, localInnerActive, localError, localQueue, localChild, localQueue.isEmpty())) {
                        return;
                    }
                }
                SwitchSubscriber switchSubscriber2 = this;
                synchronized (switchSubscriber2) {
                    localRequested = this.requested;
                    if (localRequested != Long.MAX_VALUE) {
                        this.requested = localRequested -= localEmission;
                    }
                    if (!this.missed) {
                        this.emitting = false;
                        return;
                    }
                    this.missed = false;
                    localMainDone = this.mainDone;
                    localInnerActive = this.innerActive;
                    localError = this.error;
                    if (localError != null && localError != TERMINAL_ERROR && !this.delayError) {
                        this.error = TERMINAL_ERROR;
                    }
                }
            }
        }

        protected boolean checkTerminated(boolean localMainDone, boolean localInnerActive, Throwable localError, SpscLinkedArrayQueue<Object> localQueue, Subscriber<? super T> localChild, boolean empty) {
            if (this.delayError) {
                if (localMainDone && !localInnerActive && empty) {
                    if (localError != null) {
                        localChild.onError(localError);
                    } else {
                        localChild.onCompleted();
                    }
                    return true;
                }
            } else {
                if (localError != null) {
                    localQueue.clear();
                    localChild.onError(localError);
                    return true;
                }
                if (localMainDone && !localInnerActive && empty) {
                    localChild.onCompleted();
                    return true;
                }
            }
            return false;
        }
    }

    static final class HolderDelayError {
        static final OperatorSwitch<Object> INSTANCE = new OperatorSwitch(true);

        HolderDelayError() {
        }
    }

    static final class Holder {
        static final OperatorSwitch<Object> INSTANCE = new OperatorSwitch(false);

        Holder() {
        }
    }
}

