/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner.options;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConversionException;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.profile.ProfilerFactory;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Defaults;
import org.openjdk.jmh.runner.options.CommandLineOptionException;
import org.openjdk.jmh.runner.options.IntegerValueConverter;
import org.openjdk.jmh.runner.options.OptionFormatter;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.ProfilerConfig;
import org.openjdk.jmh.runner.options.ThreadsValueConverter;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.Optional;
import org.openjdk.jmh.util.Utils;

public class CommandLineOptions
implements Options {
    private static final long serialVersionUID = 5565183446360224399L;
    private final Optional<Integer> iterations;
    private final Optional<TimeValue> timeout;
    private final Optional<TimeValue> runTime;
    private final Optional<Integer> batchSize;
    private final Optional<Integer> warmupIterations;
    private final Optional<TimeValue> warmupTime;
    private final Optional<Integer> warmupBatchSize;
    private final List<Mode> benchMode = new ArrayList<Mode>();
    private final Optional<Integer> threads;
    private final List<Integer> threadGroups = new ArrayList<Integer>();
    private final Optional<Boolean> synchIterations;
    private final Optional<Boolean> gcEachIteration;
    private final Optional<VerboseMode> verbose;
    private final Optional<Boolean> failOnError;
    private final List<ProfilerConfig> profilers = new ArrayList<ProfilerConfig>();
    private final Optional<TimeUnit> timeUnit;
    private final Optional<Integer> opsPerInvocation;
    private final List<String> regexps = new ArrayList<String>();
    private final Optional<Integer> fork;
    private final Optional<Integer> warmupFork;
    private final Optional<String> output;
    private final Optional<String> result;
    private final Optional<ResultFormatType> resultFormat;
    private final Optional<String> jvm;
    private final Optional<Collection<String>> jvmArgs;
    private final Optional<Collection<String>> jvmArgsAppend;
    private final Optional<Collection<String>> jvmArgsPrepend;
    private final List<String> excludes = new ArrayList<String>();
    private final Optional<WarmupMode> warmupMode;
    private final List<String> warmupMicros = new ArrayList<String>();
    private final Multimap<String, String> params = new HashMultimap<String, String>();
    private final boolean list;
    private final boolean listWithParams;
    private final boolean listResultFormats;
    private final boolean help;
    private final boolean listProfilers;
    private final transient OptionParser parser = new OptionParser();

    public CommandLineOptions(String ... argv) throws CommandLineOptionException {
        this.parser.formatHelpWith(new OptionFormatter());
        ArgumentAcceptingOptionSpec<Integer> optMeasureCount = this.parser.accepts("i", "Number of measurement iterations to do. Measurement iterations are counted towards the benchmark score. (default: 1 for " + (Object)((Object)Mode.SingleShotTime) + ", and " + 5 + " for all other modes)").withRequiredArg().withValuesConvertedBy(IntegerValueConverter.POSITIVE).describedAs("int");
        ArgumentAcceptingOptionSpec<Integer> optMeasureBatchSize = this.parser.accepts("bs", "Batch size: number of benchmark method calls per operation. Some benchmark modes may ignore this setting, please check this separately. (default: 1)").withRequiredArg().withValuesConvertedBy(IntegerValueConverter.POSITIVE).describedAs("int");
        ArgumentAcceptingOptionSpec<TimeValue> optMeasureTime = this.parser.accepts("r", "Minimum time to spend at each measurement iteration. Benchmarks may generally run longer than iteration duration. (default: " + Defaults.MEASUREMENT_TIME + ")").withRequiredArg().ofType(TimeValue.class).describedAs("time");
        ArgumentAcceptingOptionSpec<Integer> optWarmupCount = this.parser.accepts("wi", "Number of warmup iterations to do. Warmup iterations are not counted towards the benchmark score. (default: 0 for " + (Object)((Object)Mode.SingleShotTime) + ", and " + 5 + " for all other modes)").withRequiredArg().withValuesConvertedBy(IntegerValueConverter.NON_NEGATIVE).describedAs("int");
        ArgumentAcceptingOptionSpec<Integer> optWarmupBatchSize = this.parser.accepts("wbs", "Warmup batch size: number of benchmark method calls per operation. Some benchmark modes may ignore this setting. (default: 1)").withRequiredArg().withValuesConvertedBy(IntegerValueConverter.POSITIVE).describedAs("int");
        ArgumentAcceptingOptionSpec<TimeValue> optWarmupTime = this.parser.accepts("w", "Minimum time to spend at each warmup iteration. Benchmarks may generally run longer than iteration duration. (default: " + Defaults.WARMUP_TIME + ")").withRequiredArg().ofType(TimeValue.class).describedAs("time");
        ArgumentAcceptingOptionSpec<TimeValue> optTimeoutTime = this.parser.accepts("to", "Timeout for benchmark iteration. After reaching this timeout, JMH will try to interrupt the running tasks. Non-cooperating benchmarks may ignore this timeout. (default: " + Defaults.TIMEOUT + ")").withRequiredArg().ofType(TimeValue.class).describedAs("time");
        ArgumentAcceptingOptionSpec<Integer> optThreads = this.parser.accepts("t", "Number of worker threads to run with. 'max' means the maximum number of hardware threads available on the machine, figured out by JMH itself. (default: 1)").withRequiredArg().withValuesConvertedBy(ThreadsValueConverter.INSTANCE).describedAs("int");
        ArgumentAcceptingOptionSpec<String> optBenchmarkMode = this.parser.accepts("bm", "Benchmark mode. Available modes are: " + Mode.getKnown() + ". (default: " + (Object)((Object)Defaults.BENCHMARK_MODE) + ")").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("mode");
        ArgumentAcceptingOptionSpec<Boolean> optSyncIters = this.parser.accepts("si", "Should JMH synchronize iterations? This would significantly lower the noise in multithreaded tests, by making sure the measured part happens only when all workers are running. (default: true)").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<Boolean> optGC = this.parser.accepts("gc", "Should JMH force GC between iterations? Forcing the GC may help to lower the noise in GC-heavy benchmarks, at the expense of jeopardizing GC ergonomics decisions. Use with care. (default: false)").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<Boolean> optFOE = this.parser.accepts("foe", "Should JMH fail immediately if any benchmark had experienced an unrecoverable error? This helps to make quick sanity tests for benchmark suites, as well as make the automated runs with checking error codes. (default: false)").withRequiredArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<String> optVerboseMode = this.parser.accepts("v", "Verbosity mode. Available modes are: " + Arrays.toString((Object[])VerboseMode.values()) + ". (default: " + (Object)((Object)Defaults.VERBOSITY) + ")").withRequiredArg().ofType(String.class).describedAs("mode");
        NonOptionArgumentSpec<String> optArgs = this.parser.nonOptions("Benchmarks to run (regexp+). (default: .*)").describedAs("regexp+");
        ArgumentAcceptingOptionSpec<Integer> optForks = this.parser.accepts("f", "How many times to fork a single benchmark. Use 0 to disable forking altogether. Warning: disabling forking may have detrimental impact on benchmark and infrastructure reliability, you might want to use different warmup mode instead. (default: 5)").withRequiredArg().withValuesConvertedBy(IntegerValueConverter.NON_NEGATIVE).describedAs("int");
        ArgumentAcceptingOptionSpec<Integer> optWarmupForks = this.parser.accepts("wf", "How many warmup forks to make for a single benchmark. All iterations within the warmup fork are not counted towards the benchmark score. Use 0 to disable warmup forks. (default: 0)").withRequiredArg().withValuesConvertedBy(IntegerValueConverter.NON_NEGATIVE).describedAs("int");
        ArgumentAcceptingOptionSpec<String> optOutput = this.parser.accepts("o", "Redirect human-readable output to a given file.").withRequiredArg().ofType(String.class).describedAs("filename");
        ArgumentAcceptingOptionSpec<String> optOutputResults = this.parser.accepts("rff", "Write machine-readable results to a given file. The file format is controlled by -rf option. Please see the list of result formats for available formats. (default: jmh-result.<result-format>)").withRequiredArg().ofType(String.class).describedAs("filename");
        ArgumentAcceptingOptionSpec<String> optProfilers = this.parser.accepts("prof", "Use profilers to collect additional benchmark data. Some profilers are not available on all JVMs and/or all OSes. Please see the list of available profilers with -lprof.").withRequiredArg().ofType(String.class).describedAs("profiler");
        ArgumentAcceptingOptionSpec<Integer> optThreadGroups = this.parser.accepts("tg", "Override thread group distribution for asymmetric benchmarks. This option expects a comma-separated list of thread counts within the group. See @Group/@GroupThreads Javadoc for more information.").withRequiredArg().withValuesSeparatedBy(',').ofType(Integer.class).withValuesConvertedBy(IntegerValueConverter.NON_NEGATIVE).describedAs("int+");
        ArgumentAcceptingOptionSpec<String> optJvm = this.parser.accepts("jvm", "Use given JVM for runs. This option only affects forked runs.").withRequiredArg().ofType(String.class).describedAs("string");
        ArgumentAcceptingOptionSpec<String> optJvmArgs = this.parser.accepts("jvmArgs", "Use given JVM arguments. Most options are inherited from the host VM options, but in some cases you want to pass the options only to a forked VM. Either single space-separated option line, or multiple options are accepted. This option only affects forked runs.").withRequiredArg().ofType(String.class).describedAs("string");
        ArgumentAcceptingOptionSpec<String> optJvmArgsAppend = this.parser.accepts("jvmArgsAppend", "Same as jvmArgs, but append these options after the already given JVM args.").withRequiredArg().ofType(String.class).describedAs("string");
        ArgumentAcceptingOptionSpec<String> optJvmArgsPrepend = this.parser.accepts("jvmArgsPrepend", "Same as jvmArgs, but prepend these options before the already given JVM arg.").withRequiredArg().ofType(String.class).describedAs("string");
        ArgumentAcceptingOptionSpec<String> optTU = this.parser.accepts("tu", "Override time unit in benchmark results. Available time units are: [m, s, ms, us, ns]. (default: " + (Object)((Object)Defaults.OUTPUT_TIMEUNIT) + ")").withRequiredArg().ofType(String.class).describedAs("TU");
        ArgumentAcceptingOptionSpec<Integer> optOPI = this.parser.accepts("opi", "Override operations per invocation, see @OperationsPerInvocation Javadoc for details. (default: " + Defaults.OPS_PER_INVOCATION + ")").withRequiredArg().withValuesConvertedBy(IntegerValueConverter.POSITIVE).describedAs("int");
        ArgumentAcceptingOptionSpec<String> optResultFormat = this.parser.accepts("rf", "Format type for machine-readable results. These results are written to a separate file (see -rff). See the list of available result formats with -lrf. (default: " + (Object)((Object)Defaults.RESULT_FORMAT) + ")").withRequiredArg().ofType(String.class).describedAs("type");
        ArgumentAcceptingOptionSpec<String> optWarmupMode = this.parser.accepts("wm", "Warmup mode for warming up selected benchmarks. Warmup modes are: " + this.warmupModesDesc() + "(default: " + (Object)((Object)Defaults.WARMUP_MODE) + ")").withRequiredArg().ofType(String.class).describedAs("mode");
        ArgumentAcceptingOptionSpec<String> optExcludes = this.parser.accepts("e", "Benchmarks to exclude from the run.").withRequiredArg().withValuesSeparatedBy(',').ofType(String.class).describedAs("regexp+");
        ArgumentAcceptingOptionSpec<String> optParams = this.parser.accepts("p", "Benchmark parameters. This option is expected to be used once per parameter. Parameter name and parameter values should be separated with equals sign. Parameter values should be separated with commas.").withRequiredArg().ofType(String.class).describedAs("param={v,}*");
        ArgumentAcceptingOptionSpec<String> optWarmupBenchmarks = this.parser.accepts("wmb", "Warmup benchmarks to include in the run in addition to already selected by the primary filters. Harness will not measure these benchmarks, but only use them for the warmup.").withRequiredArg().withValuesSeparatedBy(',').ofType(String.class).describedAs("regexp+");
        this.parser.accepts("l", "List the benchmarks that match a filter, and exit.");
        this.parser.accepts("lp", "List the benchmarks that match a filter, along with parameters, and exit.");
        this.parser.accepts("lrf", "List machine-readable result formats, and exit.");
        this.parser.accepts("lprof", "List profilers, and exit.");
        this.parser.accepts("h", "Display help, and exit.");
        try {
            OptionSet set = this.parser.parse(argv);
            if (set.has(optExcludes)) {
                this.excludes.addAll(optExcludes.values(set));
            }
            if (set.has(optWarmupBenchmarks)) {
                this.warmupMicros.addAll(optWarmupBenchmarks.values(set));
            }
            if (set.has(optTU)) {
                Object tu;
                String va = (String)optTU.value(set);
                if (va.equalsIgnoreCase("ns")) {
                    tu = TimeUnit.NANOSECONDS;
                } else if (va.equalsIgnoreCase("us")) {
                    tu = TimeUnit.MICROSECONDS;
                } else if (va.equalsIgnoreCase("ms")) {
                    tu = TimeUnit.MILLISECONDS;
                } else if (va.equalsIgnoreCase("s")) {
                    tu = TimeUnit.SECONDS;
                } else if (va.equalsIgnoreCase("m")) {
                    tu = TimeUnit.MINUTES;
                } else if (va.equalsIgnoreCase("h")) {
                    tu = TimeUnit.HOURS;
                } else {
                    throw new CommandLineOptionException("Unknown time unit: " + va);
                }
                this.timeUnit = Optional.of(tu);
            } else {
                this.timeUnit = Optional.none();
            }
            this.opsPerInvocation = CommandLineOptions.toOptional(optOPI, set);
            if (set.has(optWarmupMode)) {
                try {
                    this.warmupMode = Optional.of(WarmupMode.valueOf((String)optWarmupMode.value(set)));
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandLineOptionException(iae.getMessage(), iae);
                }
            } else {
                this.warmupMode = Optional.none();
            }
            if (set.has(optResultFormat)) {
                try {
                    this.resultFormat = Optional.of(ResultFormatType.valueOf(((String)optResultFormat.value(set)).toUpperCase()));
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandLineOptionException(iae.getMessage(), iae);
                }
            } else {
                this.resultFormat = Optional.none();
            }
            this.help = set.has("h");
            this.list = set.has("l");
            this.listWithParams = set.has("lp");
            this.listResultFormats = set.has("lrf");
            this.listProfilers = set.has("lprof");
            this.iterations = CommandLineOptions.toOptional(optMeasureCount, set);
            this.batchSize = CommandLineOptions.toOptional(optMeasureBatchSize, set);
            this.runTime = CommandLineOptions.toOptional(optMeasureTime, set);
            this.warmupIterations = CommandLineOptions.toOptional(optWarmupCount, set);
            this.warmupBatchSize = CommandLineOptions.toOptional(optWarmupBatchSize, set);
            this.warmupTime = CommandLineOptions.toOptional(optWarmupTime, set);
            this.timeout = CommandLineOptions.toOptional(optTimeoutTime, set);
            this.threads = CommandLineOptions.toOptional(optThreads, set);
            this.synchIterations = CommandLineOptions.toOptional(optSyncIters, set);
            this.gcEachIteration = CommandLineOptions.toOptional(optGC, set);
            this.failOnError = CommandLineOptions.toOptional(optFOE, set);
            this.fork = CommandLineOptions.toOptional(optForks, set);
            this.warmupFork = CommandLineOptions.toOptional(optWarmupForks, set);
            this.output = CommandLineOptions.toOptional(optOutput, set);
            this.result = CommandLineOptions.toOptional(optOutputResults, set);
            if (set.has(optBenchmarkMode)) {
                try {
                    ArrayList<Mode> modes = new ArrayList<Mode>();
                    for (String m3 : optBenchmarkMode.values(set)) {
                        modes.add(Mode.deepValueOf(m3));
                    }
                    this.benchMode.addAll(modes);
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandLineOptionException(iae.getMessage(), iae);
                }
            }
            if (set.has(optVerboseMode)) {
                try {
                    if (set.hasArgument(optVerboseMode)) {
                        this.verbose = Optional.of(VerboseMode.valueOf(set.valueOf(optVerboseMode).toUpperCase()));
                    }
                    this.verbose = Optional.of(VerboseMode.EXTRA);
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandLineOptionException(iae.getMessage(), iae);
                }
            } else {
                this.verbose = Optional.none();
            }
            this.regexps.addAll(set.valuesOf(optArgs));
            if (set.has(optProfilers)) {
                try {
                    for (Object m4 : optProfilers.values(set)) {
                        int idx = ((String)m4).indexOf(":");
                        Object profName = idx == -1 ? m4 : ((String)m4).substring(0, idx);
                        String params = idx == -1 ? "" : ((String)m4).substring(idx + 1);
                        this.profilers.add(new ProfilerConfig((String)profName, params));
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandLineOptionException(iae.getMessage(), iae);
                }
            }
            if (set.has(optThreadGroups)) {
                Object m4;
                this.threadGroups.addAll(set.valuesOf(optThreadGroups));
                int total = 0;
                m4 = this.threadGroups.iterator();
                while (m4.hasNext()) {
                    int group = (Integer)m4.next();
                    total += group;
                }
                if (total <= 0) {
                    throw new CommandLineOptionException("Group thread count should be positive, but it is " + total);
                }
            }
            this.jvm = CommandLineOptions.toOptional(optJvm, set);
            this.jvmArgs = this.treatQuoted(set, optJvmArgs);
            this.jvmArgsAppend = this.treatQuoted(set, optJvmArgsAppend);
            this.jvmArgsPrepend = this.treatQuoted(set, optJvmArgsPrepend);
            if (set.hasArgument(optParams)) {
                for (String p : optParams.values(set)) {
                    String[] keys = p.split("=", 2);
                    if (keys.length != 2) {
                        throw new CommandLineOptionException("Unable to parse parameter string \"" + p + "\"");
                    }
                    this.params.putAll(keys[0], Arrays.asList(keys[1].split(",")));
                }
            }
        }
        catch (OptionException e) {
            String message = e.getMessage();
            Throwable cause = e.getCause();
            if (cause instanceof ValueConversionException) {
                message = message + ". " + cause.getMessage();
            }
            throw new CommandLineOptionException(message, e);
        }
    }

    private String warmupModesDesc() {
        StringBuilder sb = new StringBuilder();
        block5: for (WarmupMode mode : WarmupMode.values()) {
            sb.append((Object)mode);
            sb.append(" = ");
            switch (mode) {
                case BULK: {
                    sb.append("Warmup all benchmarks first, then do all the measurements. ");
                    continue block5;
                }
                case INDI: {
                    sb.append("Warmup each benchmark individually, then measure it. ");
                    continue block5;
                }
                case BULK_INDI: {
                    sb.append("Warmup all benchmarks first, then re-warmup each benchmark individually, then measure it. ");
                }
            }
        }
        return sb.toString();
    }

    private static <T> Optional<T> toOptional(OptionSpec<T> option, OptionSet set) {
        if (set.has(option)) {
            return Optional.eitherOf(option.value(set));
        }
        return Optional.none();
    }

    public Optional<Collection<String>> treatQuoted(OptionSet set, OptionSpec<String> spec) {
        if (set.hasArgument(spec)) {
            try {
                List<String> vals = spec.values(set);
                if (vals.size() != 1) {
                    return Optional.of(vals);
                }
            }
            catch (OptionException optionException) {
                // empty catch block
            }
            return Optional.of(Utils.splitQuotedEscape(spec.value(set)));
        }
        return Optional.none();
    }

    public void showHelp() throws IOException {
        this.parser.printHelpOn(System.err);
    }

    public void listProfilers() {
        ProfilerFactory.listProfilers(System.out);
    }

    public void listResultFormats() {
        StringBuilder sb = new StringBuilder();
        for (ResultFormatType f : ResultFormatType.values()) {
            sb.append(f.toString().toLowerCase());
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        System.out.println("Available formats: " + sb.toString());
    }

    public boolean shouldList() {
        return this.list;
    }

    public boolean shouldListWithParams() {
        return this.listWithParams;
    }

    public boolean shouldListResultFormats() {
        return this.listResultFormats;
    }

    public boolean shouldHelp() {
        return this.help;
    }

    public boolean shouldListProfilers() {
        return this.listProfilers;
    }

    @Override
    public Optional<WarmupMode> getWarmupMode() {
        return this.warmupMode;
    }

    @Override
    public List<String> getIncludes() {
        return this.regexps;
    }

    @Override
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public List<String> getWarmupIncludes() {
        return this.warmupMicros;
    }

    @Override
    public Optional<String> getJvm() {
        return this.jvm;
    }

    @Override
    public Optional<Collection<String>> getJvmArgs() {
        return this.jvmArgs;
    }

    @Override
    public Optional<Collection<String>> getJvmArgsAppend() {
        return this.jvmArgsAppend;
    }

    @Override
    public Optional<Collection<String>> getJvmArgsPrepend() {
        return this.jvmArgsPrepend;
    }

    @Override
    public Optional<Collection<String>> getParameter(String name) {
        Collection<String> list = this.params.get(name);
        if (list == null || list.isEmpty()) {
            return Optional.none();
        }
        return Optional.of(list);
    }

    @Override
    public Optional<Integer> getForkCount() {
        return this.fork;
    }

    @Override
    public Optional<Integer> getWarmupForkCount() {
        return this.warmupFork;
    }

    @Override
    public Optional<String> getOutput() {
        return this.output;
    }

    @Override
    public Optional<ResultFormatType> getResultFormat() {
        return this.resultFormat;
    }

    @Override
    public Optional<String> getResult() {
        return this.result;
    }

    @Override
    public Optional<Integer> getMeasurementIterations() {
        return this.iterations;
    }

    @Override
    public Optional<Integer> getMeasurementBatchSize() {
        return this.batchSize;
    }

    @Override
    public Optional<TimeValue> getMeasurementTime() {
        return this.runTime;
    }

    @Override
    public Optional<TimeValue> getWarmupTime() {
        return this.warmupTime;
    }

    @Override
    public Optional<Integer> getWarmupIterations() {
        return this.warmupIterations;
    }

    @Override
    public Optional<Integer> getWarmupBatchSize() {
        return this.warmupBatchSize;
    }

    @Override
    public Optional<Integer> getThreads() {
        return this.threads;
    }

    @Override
    public Optional<int[]> getThreadGroups() {
        if (this.threadGroups.isEmpty()) {
            return Optional.none();
        }
        int[] r = new int[this.threadGroups.size()];
        for (int c = 0; c < r.length; ++c) {
            r[c] = this.threadGroups.get(c);
        }
        return Optional.of(r);
    }

    @Override
    public Optional<Boolean> shouldDoGC() {
        return this.gcEachIteration;
    }

    @Override
    public Optional<Boolean> shouldSyncIterations() {
        return this.synchIterations;
    }

    @Override
    public Optional<VerboseMode> verbosity() {
        return this.verbose;
    }

    @Override
    public Optional<TimeUnit> getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public Optional<Integer> getOperationsPerInvocation() {
        return this.opsPerInvocation;
    }

    @Override
    public Optional<Boolean> shouldFailOnError() {
        return this.failOnError;
    }

    @Override
    public List<ProfilerConfig> getProfilers() {
        return this.profilers;
    }

    @Override
    public Collection<Mode> getBenchModes() {
        return new HashSet<Mode>(this.benchMode);
    }

    @Override
    public Optional<TimeValue> getTimeout() {
        return this.timeout;
    }
}

