/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicSplineFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.MathArrays;

public class BicubicSplineInterpolatingFunction
implements BivariateFunction {
    private static final double[][] AINV = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {-3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, -3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0}, {9.0, -9.0, -9.0, 9.0, 6.0, 3.0, -6.0, -3.0, 6.0, -6.0, 3.0, -3.0, 4.0, 2.0, 2.0, 1.0}, {-6.0, 6.0, 6.0, -6.0, -3.0, -3.0, 3.0, 3.0, -4.0, 4.0, -2.0, 2.0, -2.0, -2.0, -1.0, -1.0}, {2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0}, {-6.0, 6.0, 6.0, -6.0, -4.0, -2.0, 4.0, 2.0, -3.0, 3.0, -3.0, 3.0, -2.0, -1.0, -2.0, -1.0}, {4.0, -4.0, -4.0, 4.0, 2.0, 2.0, -2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 1.0, 1.0, 1.0, 1.0}};
    private final double[] xval;
    private final double[] yval;
    private final BicubicSplineFunction[][] splines;
    private BivariateFunction[][][] partialDerivatives = null;

    public BicubicSplineInterpolatingFunction(double[] x, double[] y, double[][] f, double[][] dFdX, double[][] dFdY, double[][] d2FdXdY) throws DimensionMismatchException, NoDataException, NonMonotonicSequenceException {
        int xLen = x.length;
        int yLen = y.length;
        if (xLen == 0 || yLen == 0 || f.length == 0 || f[0].length == 0) {
            throw new NoDataException();
        }
        if (xLen != f.length) {
            throw new DimensionMismatchException(xLen, f.length);
        }
        if (xLen != dFdX.length) {
            throw new DimensionMismatchException(xLen, dFdX.length);
        }
        if (xLen != dFdY.length) {
            throw new DimensionMismatchException(xLen, dFdY.length);
        }
        if (xLen != d2FdXdY.length) {
            throw new DimensionMismatchException(xLen, d2FdXdY.length);
        }
        MathArrays.checkOrder(x);
        MathArrays.checkOrder(y);
        this.xval = (double[])x.clone();
        this.yval = (double[])y.clone();
        int lastI = xLen - 1;
        int lastJ = yLen - 1;
        this.splines = new BicubicSplineFunction[lastI][lastJ];
        for (int i2 = 0; i2 < lastI; ++i2) {
            if (f[i2].length != yLen) {
                throw new DimensionMismatchException(f[i2].length, yLen);
            }
            if (dFdX[i2].length != yLen) {
                throw new DimensionMismatchException(dFdX[i2].length, yLen);
            }
            if (dFdY[i2].length != yLen) {
                throw new DimensionMismatchException(dFdY[i2].length, yLen);
            }
            if (d2FdXdY[i2].length != yLen) {
                throw new DimensionMismatchException(d2FdXdY[i2].length, yLen);
            }
            int ip1 = i2 + 1;
            for (int j = 0; j < lastJ; ++j) {
                int jp1 = j + 1;
                double[] beta = new double[]{f[i2][j], f[ip1][j], f[i2][jp1], f[ip1][jp1], dFdX[i2][j], dFdX[ip1][j], dFdX[i2][jp1], dFdX[ip1][jp1], dFdY[i2][j], dFdY[ip1][j], dFdY[i2][jp1], dFdY[ip1][jp1], d2FdXdY[i2][j], d2FdXdY[ip1][j], d2FdXdY[i2][jp1], d2FdXdY[ip1][jp1]};
                this.splines[i2][j] = new BicubicSplineFunction(this.computeSplineCoefficients(beta));
            }
        }
    }

    public double value(double x, double y) throws OutOfRangeException {
        int i2 = this.searchIndex(x, this.xval);
        if (i2 == -1) {
            throw new OutOfRangeException(x, (Number)this.xval[0], this.xval[this.xval.length - 1]);
        }
        int j = this.searchIndex(y, this.yval);
        if (j == -1) {
            throw new OutOfRangeException(y, (Number)this.yval[0], this.yval[this.yval.length - 1]);
        }
        double xN = (x - this.xval[i2]) / (this.xval[i2 + 1] - this.xval[i2]);
        double yN = (y - this.yval[j]) / (this.yval[j + 1] - this.yval[j]);
        return this.splines[i2][j].value(xN, yN);
    }

    public double partialDerivativeX(double x, double y) throws OutOfRangeException {
        return this.partialDerivative(0, x, y);
    }

    public double partialDerivativeY(double x, double y) throws OutOfRangeException {
        return this.partialDerivative(1, x, y);
    }

    public double partialDerivativeXX(double x, double y) throws OutOfRangeException {
        return this.partialDerivative(2, x, y);
    }

    public double partialDerivativeYY(double x, double y) throws OutOfRangeException {
        return this.partialDerivative(3, x, y);
    }

    public double partialDerivativeXY(double x, double y) throws OutOfRangeException {
        return this.partialDerivative(4, x, y);
    }

    private double partialDerivative(int which, double x, double y) throws OutOfRangeException {
        int i2;
        if (this.partialDerivatives == null) {
            this.computePartialDerivatives();
        }
        if ((i2 = this.searchIndex(x, this.xval)) == -1) {
            throw new OutOfRangeException(x, (Number)this.xval[0], this.xval[this.xval.length - 1]);
        }
        int j = this.searchIndex(y, this.yval);
        if (j == -1) {
            throw new OutOfRangeException(y, (Number)this.yval[0], this.yval[this.yval.length - 1]);
        }
        double xN = (x - this.xval[i2]) / (this.xval[i2 + 1] - this.xval[i2]);
        double yN = (y - this.yval[j]) / (this.yval[j + 1] - this.yval[j]);
        return this.partialDerivatives[which][i2][j].value(xN, yN);
    }

    private void computePartialDerivatives() {
        int lastI = this.xval.length - 1;
        int lastJ = this.yval.length - 1;
        this.partialDerivatives = new BivariateFunction[5][lastI][lastJ];
        for (int i2 = 0; i2 < lastI; ++i2) {
            for (int j = 0; j < lastJ; ++j) {
                BicubicSplineFunction f = this.splines[i2][j];
                this.partialDerivatives[0][i2][j] = f.partialDerivativeX();
                this.partialDerivatives[1][i2][j] = f.partialDerivativeY();
                this.partialDerivatives[2][i2][j] = f.partialDerivativeXX();
                this.partialDerivatives[3][i2][j] = f.partialDerivativeYY();
                this.partialDerivatives[4][i2][j] = f.partialDerivativeXY();
            }
        }
    }

    private int searchIndex(double c, double[] val) {
        if (c < val[0]) {
            return -1;
        }
        int max = val.length;
        for (int i2 = 1; i2 < max; ++i2) {
            if (!(c <= val[i2])) continue;
            return i2 - 1;
        }
        return -1;
    }

    private double[] computeSplineCoefficients(double[] beta) {
        double[] a = new double[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            double result = 0.0;
            double[] row = AINV[i2];
            for (int j = 0; j < 16; ++j) {
                result += row[j] * beta[j];
            }
            a[i2] = result;
        }
        return a;
    }
}

