/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.google.common.base.Function;

public class CaseInsensitiveKey {
    private final String key;
    private int hash;
    public static final Function<String, CaseInsensitiveKey> TO_CASE_INSENSITIVE_KEYS = new Function<String, CaseInsensitiveKey>(){

        @Override
        public CaseInsensitiveKey apply(String input) {
            return CaseInsensitiveKey.from(input);
        }
    };

    public CaseInsensitiveKey(String key) {
        this.key = key;
    }

    public static CaseInsensitiveKey from(String key) {
        return new CaseInsensitiveKey(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseInsensitiveKey that = (CaseInsensitiveKey)o;
        return !(this.key != null ? !this.key.equalsIgnoreCase(that.key) : that.key != null);
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0 && this.key.length() > 0) {
            for (int i2 = 0; i2 < this.key.length(); ++i2) {
                char c = Character.toLowerCase(this.key.charAt(i2));
                h2 = 31 * h2 + c;
            }
            this.hash = h2;
        }
        return h2;
    }

    public String toString() {
        return this.key;
    }

    public String value() {
        return this.key;
    }
}

