/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Subscription;
import rx.internal.operators.CompletableOnSubscribeMerge;
import rx.internal.util.atomic.MpscLinkedAtomicQueue;
import rx.internal.util.unsafe.MpscLinkedQueue;
import rx.internal.util.unsafe.UnsafeAccess;
import rx.subscriptions.CompositeSubscription;

public final class CompletableOnSubscribeMergeDelayErrorIterable
implements Completable.OnSubscribe {
    final Iterable<? extends Completable> sources;

    public CompletableOnSubscribeMergeDelayErrorIterable(Iterable<? extends Completable> sources) {
        this.sources = sources;
    }

    @Override
    public void call(final CompletableSubscriber s2) {
        Iterator<? extends Completable> iterator;
        final CompositeSubscription set = new CompositeSubscription();
        s2.onSubscribe(set);
        try {
            iterator = this.sources.iterator();
        }
        catch (Throwable e) {
            s2.onError(e);
            return;
        }
        if (iterator == null) {
            s2.onError(new NullPointerException("The source iterator returned is null"));
            return;
        }
        final AtomicInteger wip = new AtomicInteger(1);
        final AbstractQueue queue = UnsafeAccess.isUnsafeAvailable() ? new MpscLinkedQueue() : new MpscLinkedAtomicQueue();
        while (true) {
            Completable c;
            boolean b;
            if (set.isUnsubscribed()) {
                return;
            }
            try {
                b = iterator.hasNext();
            }
            catch (Throwable e) {
                queue.offer(e);
                if (wip.decrementAndGet() == 0) {
                    if (queue.isEmpty()) {
                        s2.onCompleted();
                    } else {
                        s2.onError(CompletableOnSubscribeMerge.collectErrors(queue));
                    }
                }
                return;
            }
            if (!b) break;
            if (set.isUnsubscribed()) {
                return;
            }
            try {
                c = iterator.next();
            }
            catch (Throwable e) {
                queue.offer(e);
                if (wip.decrementAndGet() == 0) {
                    if (queue.isEmpty()) {
                        s2.onCompleted();
                    } else {
                        s2.onError(CompletableOnSubscribeMerge.collectErrors(queue));
                    }
                }
                return;
            }
            if (set.isUnsubscribed()) {
                return;
            }
            if (c == null) {
                NullPointerException e = new NullPointerException("A completable source is null");
                queue.offer(e);
                if (wip.decrementAndGet() == 0) {
                    if (queue.isEmpty()) {
                        s2.onCompleted();
                    } else {
                        s2.onError(CompletableOnSubscribeMerge.collectErrors(queue));
                    }
                }
                return;
            }
            wip.getAndIncrement();
            c.unsafeSubscribe(new CompletableSubscriber(){

                @Override
                public void onSubscribe(Subscription d) {
                    set.add(d);
                }

                @Override
                public void onError(Throwable e) {
                    queue.offer(e);
                    this.tryTerminate();
                }

                @Override
                public void onCompleted() {
                    this.tryTerminate();
                }

                void tryTerminate() {
                    if (wip.decrementAndGet() == 0) {
                        if (queue.isEmpty()) {
                            s2.onCompleted();
                        } else {
                            s2.onError(CompletableOnSubscribeMerge.collectErrors(queue));
                        }
                    }
                }
            });
        }
        if (wip.decrementAndGet() == 0) {
            if (queue.isEmpty()) {
                s2.onCompleted();
            } else {
                s2.onError(CompletableOnSubscribeMerge.collectErrors(queue));
            }
        }
    }
}

