/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results.format;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormat;
import org.openjdk.jmh.util.Statistics;
import org.openjdk.jmh.util.Utils;

class JSONResultFormat
implements ResultFormat {
    private static final boolean PRINT_RAW_DATA = Boolean.parseBoolean(System.getProperty("jmh.json.rawData", "true"));
    private final PrintStream out;

    public JSONResultFormat(PrintStream out) {
        this.out = out;
    }

    @Override
    public void writeOut(Collection<RunResult> results) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        boolean first = true;
        pw.println("[");
        for (RunResult runResult : results) {
            BenchmarkParams params = runResult.getParams();
            if (first) {
                first = false;
                pw.println();
            } else {
                pw.println(",");
            }
            pw.println("{");
            pw.println("\"jmhVersion\" : \"" + params.getJmhVersion() + "\",");
            pw.println("\"benchmark\" : \"" + params.getBenchmark() + "\",");
            pw.println("\"mode\" : \"" + params.getMode().shortLabel() + "\",");
            pw.println("\"threads\" : " + params.getThreads() + ",");
            pw.println("\"forks\" : " + params.getForks() + ",");
            pw.println("\"jvm\" : " + JSONResultFormat.toJsonString(params.getJvm()) + ",");
            pw.println("\"jvmArgs\" : [");
            JSONResultFormat.printStringArray(pw, params.getJvmArgs());
            pw.println("],");
            pw.println("\"jdkVersion\" : " + JSONResultFormat.toJsonString(params.getJdkVersion()) + ",");
            pw.println("\"vmName\" : " + JSONResultFormat.toJsonString(params.getVmName()) + ",");
            pw.println("\"vmVersion\" : " + JSONResultFormat.toJsonString(params.getVmVersion()) + ",");
            pw.println("\"warmupIterations\" : " + params.getWarmup().getCount() + ",");
            pw.println("\"warmupTime\" : \"" + params.getWarmup().getTime() + "\",");
            pw.println("\"warmupBatchSize\" : " + params.getWarmup().getBatchSize() + ",");
            pw.println("\"measurementIterations\" : " + params.getMeasurement().getCount() + ",");
            pw.println("\"measurementTime\" : \"" + params.getMeasurement().getTime() + "\",");
            pw.println("\"measurementBatchSize\" : " + params.getMeasurement().getBatchSize() + ",");
            if (!params.getParamsKeys().isEmpty()) {
                pw.println("\"params\" : {");
                pw.println(this.emitParams(params));
                pw.println("},");
            }
            Result primaryResult = runResult.getPrimaryResult();
            pw.println("\"primaryMetric\" : {");
            pw.println("\"score\" : " + this.emit(primaryResult.getScore()) + ",");
            pw.println("\"scoreError\" : " + this.emit(primaryResult.getScoreError()) + ",");
            pw.println("\"scoreConfidence\" : " + this.emit(primaryResult.getScoreConfidence()) + ",");
            pw.println(this.emitPercentiles(primaryResult.getStatistics()));
            pw.println("\"scoreUnit\" : \"" + primaryResult.getScoreUnit() + "\",");
            switch (params.getMode()) {
                case SampleTime: {
                    pw.println("\"rawDataHistogram\" :");
                    pw.println(this.getRawData(runResult, true));
                    break;
                }
                default: {
                    pw.println("\"rawData\" :");
                    pw.println(this.getRawData(runResult, false));
                }
            }
            pw.println("},");
            ArrayList<String> secondaries = new ArrayList<String>();
            for (Map.Entry<String, Result> e : runResult.getSecondaryResults().entrySet()) {
                String secondaryName = e.getKey();
                Result result = e.getValue();
                StringBuilder sb = new StringBuilder();
                sb.append("\"").append(secondaryName).append("\" : {");
                sb.append("\"score\" : ").append(this.emit(result.getScore())).append(",");
                sb.append("\"scoreError\" : ").append(this.emit(result.getScoreError())).append(",");
                sb.append("\"scoreConfidence\" : ").append(this.emit(result.getScoreConfidence())).append(",");
                sb.append(this.emitPercentiles(result.getStatistics()));
                sb.append("\"scoreUnit\" : \"").append(result.getScoreUnit()).append("\",");
                sb.append("\"rawData\" : ");
                ArrayList<String> l2 = new ArrayList<String>();
                for (BenchmarkResult benchmarkResult : runResult.getBenchmarkResults()) {
                    ArrayList<String> scores = new ArrayList<String>();
                    for (IterationResult r : benchmarkResult.getIterationResults()) {
                        Result rr = r.getSecondaryResults().get(secondaryName);
                        if (rr == null) continue;
                        scores.add(this.emit(rr.getScore()));
                    }
                    l2.add(this.printMultiple(scores, "[", "]"));
                }
                sb.append(this.printMultiple(l2, "[", "]"));
                sb.append("}");
                secondaries.add(sb.toString());
            }
            pw.println("\"secondaryMetrics\" : {");
            pw.println(this.printMultiple(secondaries, "", ""));
            pw.println("}");
            pw.print("}");
        }
        pw.println("]");
        this.out.println(JSONResultFormat.tidy(sw.toString()));
    }

    private String getRawData(RunResult runResult, boolean histogram) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> runs = new ArrayList<String>();
        if (PRINT_RAW_DATA) {
            for (BenchmarkResult benchmarkResult : runResult.getBenchmarkResults()) {
                ArrayList<String> iterations = new ArrayList<String>();
                for (IterationResult r : benchmarkResult.getIterationResults()) {
                    if (histogram) {
                        ArrayList<String> singleIter = new ArrayList<String>();
                        for (Map.Entry<Double, Long> item : Utils.adaptForLoop(r.getPrimaryResult().getStatistics().getRawData())) {
                            singleIter.add("< " + this.emit(item.getKey()) + "; " + item.getValue() + " >");
                        }
                        iterations.add(this.printMultiple(singleIter, "[", "]"));
                        continue;
                    }
                    iterations.add(this.emit(r.getPrimaryResult().getScore()));
                }
                runs.add(this.printMultiple(iterations, "[", "]"));
            }
        }
        sb.append(this.printMultiple(runs, "[", "]"));
        return sb.toString();
    }

    private String emitParams(BenchmarkParams params) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String k : params.getParamsKeys()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"").append(k).append("\" : ");
            sb.append(JSONResultFormat.toJsonString(params.getParam(k)));
        }
        return sb.toString();
    }

    private String emitPercentiles(Statistics stats) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"scorePercentiles\" : {");
        boolean firstPercentile = true;
        for (double p : new double[]{0.0, 50.0, 90.0, 95.0, 99.0, 99.9, 99.99, 99.999, 99.9999, 100.0}) {
            if (firstPercentile) {
                firstPercentile = false;
            } else {
                sb.append(",");
            }
            double v = stats.getPercentile(p);
            sb.append("\"").append(this.emit(p)).append("\" : ");
            sb.append(this.emit(v));
        }
        sb.append("},");
        return sb.toString();
    }

    private String emit(double[] ds) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        sb.append("[");
        for (double d : ds) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(this.emit(d));
        }
        sb.append("]");
        return sb.toString();
    }

    private String emit(double d) {
        if (d != d) {
            return "\"NaN\"";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "\"-INF\"";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "\"+INF\"";
        }
        return String.valueOf(d);
    }

    static String toJsonString(String s2) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        block13: for (char c : s2.toCharArray()) {
            if (Character.isISOControl(c)) continue;
            switch (c) {
                case '&': {
                    sb.append("&&");
                    continue block13;
                }
                case '\\': {
                    sb.append("&/");
                    continue block13;
                }
                case '\"': {
                    sb.append("&'");
                    continue block13;
                }
                case ',': {
                    sb.append(";");
                    continue block13;
                }
                case '[': {
                    sb.append("<");
                    continue block13;
                }
                case ']': {
                    sb.append(">");
                    continue block13;
                }
                case '<': {
                    sb.append("&-");
                    continue block13;
                }
                case '>': {
                    sb.append("&=");
                    continue block13;
                }
                case ';': {
                    sb.append("&:");
                    continue block13;
                }
                case '{': {
                    sb.append("&(");
                    continue block13;
                }
                case '}': {
                    sb.append("&)");
                    continue block13;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    static String tidy(String s2) {
        s2 = s2.replaceAll("\r", "");
        s2 = s2.replaceAll("\n", " ");
        s2 = s2.replaceAll(",", ",\n");
        s2 = s2.replaceAll("\\{", "{\n");
        s2 = s2.replaceAll("\\[", "[\n");
        s2 = s2.replaceAll("\\}", "\n}\n");
        s2 = s2.replaceAll("\\]", "\n]\n");
        s2 = s2.replaceAll("\\]\n,\n", "],\n");
        s2 = s2.replaceAll("\\}\n,\n", "},\n");
        s2 = s2.replaceAll("\n( *)\n", "\n");
        s2 = s2.replaceAll(";", ",");
        s2 = s2.replaceAll("\\<", "[");
        s2 = s2.replaceAll("\\>", "]");
        s2 = s2.replaceAll("&:", ";");
        s2 = s2.replaceAll("&'", "\\\\\"");
        s2 = s2.replaceAll("&\\(", "{");
        s2 = s2.replaceAll("&\\)", "}");
        s2 = s2.replaceAll("&-", "<");
        s2 = s2.replaceAll("&=", ">");
        s2 = s2.replaceAll("&/", "\\\\\\\\");
        s2 = s2.replaceAll("&&", "&");
        String[] lines = s2.split("\n");
        StringBuilder sb = new StringBuilder();
        int ident = 0;
        String prevL = null;
        for (String l : lines) {
            if (prevL != null && (prevL.endsWith("{") || prevL.endsWith("["))) {
                ++ident;
            }
            if (l.equals("}") || l.equals("]") || l.equals("},") || l.equals("],")) {
                --ident;
            }
            for (int c = 0; c < ident; ++c) {
                sb.append("    ");
            }
            sb.append(l.trim());
            sb.append("\n");
            prevL = l;
        }
        return sb.toString();
    }

    private String printMultiple(Collection<String> elements, String leftBracket, String rightBracket) {
        StringBuilder sb = new StringBuilder();
        sb.append(leftBracket);
        boolean isFirst = true;
        for (String e : elements) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(e);
        }
        sb.append(rightBracket);
        return sb.toString();
    }

    private static void printStringArray(PrintWriter pw, Collection<String> col) {
        boolean isFirst = true;
        for (String e : col) {
            if (isFirst) {
                isFirst = false;
            } else {
                pw.print(',');
            }
            pw.print(JSONResultFormat.toJsonString(e));
        }
    }
}

