/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.CompatibilityFlags;
import com.flipkart.zjsonpatch.JsonPatchApplicationException;
import com.flipkart.zjsonpatch.JsonPatchProcessor;
import com.flipkart.zjsonpatch.Operation;
import com.flipkart.zjsonpatch.PathUtils;
import java.util.EnumSet;
import java.util.List;

class InPlaceApplyProcessor
implements JsonPatchProcessor {
    private JsonNode target;
    private EnumSet<CompatibilityFlags> flags;

    InPlaceApplyProcessor(JsonNode target) {
        this(target, CompatibilityFlags.defaults());
    }

    InPlaceApplyProcessor(JsonNode target, EnumSet<CompatibilityFlags> flags) {
        this.target = target;
        this.flags = flags;
    }

    public JsonNode result() {
        return this.target;
    }

    @Override
    public void move(List<String> fromPath, List<String> toPath) {
        JsonNode parentNode = this.getParentNode(fromPath, Operation.MOVE);
        String field = fromPath.get(fromPath.size() - 1).replaceAll("\"", "");
        JsonNode valueNode = parentNode.isArray() ? parentNode.get(Integer.parseInt(field)) : parentNode.get(field);
        this.remove(fromPath);
        this.add(toPath, valueNode);
    }

    @Override
    public void copy(List<String> fromPath, List<String> toPath) {
        JsonNode parentNode = this.getParentNode(fromPath, Operation.COPY);
        String field = fromPath.get(fromPath.size() - 1).replaceAll("\"", "");
        JsonNode valueNode = parentNode.isArray() ? parentNode.get(Integer.parseInt(field)) : parentNode.get(field);
        JsonNode valueToCopy = valueNode != null ? (JsonNode)valueNode.deepCopy() : null;
        this.add(toPath, valueToCopy);
    }

    @Override
    public void test(List<String> path2, JsonNode value) {
        if (path2.isEmpty()) {
            this.error(Operation.TEST, "path is empty , path : ");
        } else {
            JsonNode parentNode = this.getParentNode(path2, Operation.TEST);
            String fieldToReplace = path2.get(path2.size() - 1).replaceAll("\"", "");
            if (fieldToReplace.equals("") && path2.size() == 1) {
                if (this.target.equals(value)) {
                    this.target = value;
                } else {
                    this.error(Operation.TEST, "value mismatch");
                }
            } else if (!parentNode.isContainerNode()) {
                this.error(Operation.TEST, "parent is not a container in source, path provided : " + PathUtils.getPathRepresentation(path2) + " | node : " + parentNode);
            } else if (parentNode.isArray()) {
                ArrayNode target = (ArrayNode)parentNode;
                String idxStr = path2.get(path2.size() - 1);
                if ("-".equals(idxStr)) {
                    if (!target.get(target.size() - 1).equals(value)) {
                        this.error(Operation.TEST, "value mismatch");
                    }
                } else {
                    int idx = this.arrayIndex(idxStr.replaceAll("\"", ""), target.size(), false);
                    if (!target.get(idx).equals(value)) {
                        this.error(Operation.TEST, "value mismatch");
                    }
                }
            } else {
                ObjectNode target = (ObjectNode)parentNode;
                String key = path2.get(path2.size() - 1).replaceAll("\"", "");
                JsonNode actual = target.get(key);
                if (actual == null) {
                    this.error(Operation.TEST, "noSuchPath in source, path provided : " + PathUtils.getPathRepresentation(path2));
                } else if (!actual.equals(value)) {
                    this.error(Operation.TEST, "value mismatch");
                }
            }
        }
    }

    @Override
    public void add(List<String> path2, JsonNode value) {
        if (path2.isEmpty()) {
            this.error(Operation.ADD, "path is empty , path : ");
        } else {
            JsonNode parentNode = this.getParentNode(path2, Operation.ADD);
            String fieldToReplace = path2.get(path2.size() - 1).replaceAll("\"", "");
            if (fieldToReplace.equals("") && path2.size() == 1) {
                this.target = value;
            } else if (!parentNode.isContainerNode()) {
                this.error(Operation.ADD, "parent is not a container in source, path provided : " + PathUtils.getPathRepresentation(path2) + " | node : " + parentNode);
            } else if (parentNode.isArray()) {
                this.addToArray(path2, value, parentNode);
            } else {
                this.addToObject(path2, parentNode, value);
            }
        }
    }

    private void addToObject(List<String> path2, JsonNode node, JsonNode value) {
        ObjectNode target = (ObjectNode)node;
        String key = path2.get(path2.size() - 1).replaceAll("\"", "");
        target.set(key, value);
    }

    private void addToArray(List<String> path2, JsonNode value, JsonNode parentNode) {
        ArrayNode target = (ArrayNode)parentNode;
        String idxStr = path2.get(path2.size() - 1);
        if ("-".equals(idxStr)) {
            target.add(value);
        } else {
            int idx = this.arrayIndex(idxStr.replaceAll("\"", ""), target.size(), false);
            target.insert(idx, value);
        }
    }

    @Override
    public void replace(List<String> path2, JsonNode value) {
        if (path2.isEmpty()) {
            this.error(Operation.REPLACE, "path is empty");
        } else {
            JsonNode parentNode = this.getParentNode(path2, Operation.REPLACE);
            String fieldToReplace = path2.get(path2.size() - 1).replaceAll("\"", "");
            if (this.isNullOrEmpty(fieldToReplace) && path2.size() == 1) {
                this.target = value;
            } else if (parentNode.isObject() && parentNode.has(fieldToReplace)) {
                ((ObjectNode)parentNode).replace(fieldToReplace, value);
            } else if (parentNode.isArray()) {
                ((ArrayNode)parentNode).set(this.arrayIndex(fieldToReplace, parentNode.size() - 1, false), value);
            } else {
                this.error(Operation.REPLACE, "noSuchPath in source, path provided : " + PathUtils.getPathRepresentation(path2));
            }
        }
    }

    @Override
    public void remove(List<String> path2) {
        if (path2.isEmpty()) {
            this.error(Operation.REMOVE, "path is empty");
        } else {
            JsonNode parentNode = this.getParentNode(path2, Operation.REMOVE);
            String fieldToRemove = path2.get(path2.size() - 1).replaceAll("\"", "");
            if (parentNode.isObject()) {
                ((ObjectNode)parentNode).remove(fieldToRemove);
            } else if (parentNode.isArray()) {
                ((ArrayNode)parentNode).remove(this.arrayIndex(fieldToRemove, parentNode.size() - 1, this.flags.contains((Object)CompatibilityFlags.REMOVE_NONE_EXISTING_ARRAY_ELEMENT)));
            } else {
                this.error(Operation.REMOVE, "noSuchPath in source, path provided : " + PathUtils.getPathRepresentation(path2));
            }
        }
    }

    private void error(Operation forOp, String message) {
        throw new JsonPatchApplicationException("[" + (Object)((Object)forOp) + " Operation] " + message);
    }

    private JsonNode getParentNode(List<String> fromPath, Operation forOp) {
        List<String> pathToParent = fromPath.subList(0, fromPath.size() - 1);
        JsonNode node = this.getNode(this.target, pathToParent, 1);
        if (node == null) {
            this.error(forOp, "noSuchPath in source, path provided: " + PathUtils.getPathRepresentation(fromPath));
        }
        return node;
    }

    private JsonNode getNode(JsonNode ret, List<String> path2, int pos) {
        if (pos >= path2.size()) {
            return ret;
        }
        String key = path2.get(pos);
        if (ret.isArray()) {
            int keyInt = Integer.parseInt(key.replaceAll("\"", ""));
            JsonNode element = ret.get(keyInt);
            if (element == null) {
                return null;
            }
            return this.getNode(ret.get(keyInt), path2, ++pos);
        }
        if (ret.isObject()) {
            if (ret.has(key)) {
                return this.getNode(ret.get(key), path2, ++pos);
            }
            return null;
        }
        return ret;
    }

    private int arrayIndex(String s2, int max, boolean allowNoneExisting) {
        int index;
        try {
            index = Integer.parseInt(s2);
        }
        catch (NumberFormatException nfe) {
            throw new JsonPatchApplicationException("Object operation on array target");
        }
        if (index < 0) {
            throw new JsonPatchApplicationException("index Out of bound, index is negative");
        }
        if (index > max && !allowNoneExisting) {
            throw new JsonPatchApplicationException("index Out of bound, index is greater than " + max);
        }
        return index;
    }

    private boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }
}

