/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.jetty;

import reactivefeign.ReactiveOptions;

public class JettyReactiveOptions
extends ReactiveOptions {
    private final Long requestTimeoutMillis;

    private JettyReactiveOptions(Boolean useHttp2, Long connectTimeoutMillis, Long requestTimeoutMillis, Boolean tryUseCompression) {
        super(useHttp2, connectTimeoutMillis, tryUseCompression);
        this.requestTimeoutMillis = requestTimeoutMillis;
    }

    public Long getRequestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.requestTimeoutMillis == null;
    }

    public static class Builder
    extends ReactiveOptions.Builder {
        private Long requestTimeoutMillis;

        public Builder setRequestTimeoutMillis(long requestTimeoutMillis) {
            this.requestTimeoutMillis = requestTimeoutMillis;
            return this;
        }

        @Override
        public JettyReactiveOptions build() {
            return new JettyReactiveOptions(this.useHttp2, this.connectTimeoutMillis, this.requestTimeoutMillis, this.acceptCompressed);
        }
    }
}

